/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.playback.ppt;

import com.easefun.polyv.businesssdk.api.common.player.microplayer.PolyvCommonVideoView;
import com.easefun.polyv.businesssdk.api.common.ppt.IPolyvPPTView;
import com.easefun.polyv.businesssdk.api.common.ppt.IPolyvPPTWarpper;
import com.easefun.polyv.businesssdk.model.ppt.PolyvPPTInfo;
import com.easefun.polyv.livescenes.config.PolyvLiveSDKClient;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.thirdpart.blankj.utilcode.util.EncryptUtils;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class PolyvPlaybackPPTPlayWrapper
implements IPolyvPPTWarpper<PolyvPPTInfo> {
    private static final String TAG = "PolyvPlaybackPPTPlayWrapper";
    private IPolyvPPTView polyvPPTView;
    private PolyvCommonVideoView commonVideoView;
    private long videoStartTimeStamp;
    private List<PolyvPPTInfo> polyvPPTInfos;
    private boolean isPause;
    private int currentPos;
    private float speed = 1.0f;
    private Disposable currentDispose;
    private static final int DEVIATION = 800;

    public PolyvPlaybackPPTPlayWrapper(PolyvCommonVideoView polyvCommonVideoView) {
        this.commonVideoView = polyvCommonVideoView;
    }

    public void bindPPTView(IPolyvPPTView iPolyvPPTView) {
        this.polyvPPTView = iPolyvPPTView;
    }

    public void startPlay(String string, String string2) {
        if (this.polyvPPTView != null) {
            long l = System.currentTimeMillis();
            String string3 = PolyvLiveSDKClient.getInstance().getAppId();
            String string4 = PolyvLiveSDKClient.getInstance().getAppSecret();
            String string5 = string2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string4).append("appId").append(string3).append("timestamp").append(l).append("vid").append(string2).append(string4);
            String string6 = EncryptUtils.encryptMD5ToString((String)stringBuilder.toString()).toUpperCase();
            String string7 = "{ \"vid\":\"" + string5 + "\",\"appId\":\"" + string3 + "\",\"timestamp\":" + l + ",\"sign\":\"" + string6 + "\"}";
            this.polyvPPTView.pptPrepare(string7);
        }
    }

    private void play(List<PolyvPPTInfo> list, int n) {
        PLVCommonLog.d((String)TAG, (String)"play");
        if (list == null || list.isEmpty() || n >= list.size()) {
            return;
        }
        PolyvPPTInfo polyvPPTInfo = list.get(n);
        if (polyvPPTInfo != null) {
            long l = polyvPPTInfo.getTime() - this.videoStartTimeStamp;
            PLVCommonLog.d((String)TAG, (String)("play delay :" + l + "  time :" + polyvPPTInfo.getTime()));
            if (l >= 0L) {
                this.delay(list, l, n);
            } else {
                this.play(list, n + 1);
            }
        }
    }

    private void delay(List<PolyvPPTInfo> list, long l, int n) {
    }

    private void cancelTask() {
        if (this.currentDispose != null) {
            this.currentDispose.dispose();
        }
    }

    public void pause() {
        this.isPause = true;
        if (this.polyvPPTView != null) {
            String string = this.createPPTMessage(this.commonVideoView.getCurrentPosition());
            this.polyvPPTView.pause(string);
        }
    }

    public void restart() {
        if (this.polyvPPTView != null) {
            String string = this.createPPTMessage(this.commonVideoView.getCurrentPosition());
            this.polyvPPTView.play(string);
        }
    }

    public synchronized void seekTo(int n) {
        if (this.polyvPPTView != null) {
            String string = this.createPPTMessage(this.commonVideoView.getCurrentPosition());
            this.polyvPPTView.seek(string);
        }
    }

    private int binarySearch(int n, int n2, int n3) {
        while (n <= n2) {
            int n4 = (n2 + n) / 2;
            PolyvPPTInfo polyvPPTInfo = this.polyvPPTInfos.get(n4);
            if (polyvPPTInfo == null) {
                return n4;
            }
            long l = polyvPPTInfo.getTime() - this.videoStartTimeStamp;
            PLVCommonLog.d((String)TAG, (String)("search time :" + l + "   seek to " + n3));
            if (this.checkCollide(l, n3)) {
                return n4;
            }
            if (l < (long)n3) {
                n = n4 + 1;
                continue;
            }
            n2 = n4 - 1;
        }
        return -1;
    }

    private boolean checkCollide(long l, int n) {
        return Math.abs(l - (long)n) <= 800L;
    }

    public void speedUp(int n) {
        this.speed = n;
    }

    public void destory() {
        if (this.currentDispose != null) {
            this.currentDispose.dispose();
            this.currentDispose = null;
        }
    }

    private String createPPTMessage(long l) {
        return "{\"time\":" + l + "}";
    }
}

