/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyv.livescenes.chatroom.send.img;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Build;
import android.os.Environment;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendChatImageListener;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendLocalImgEvent;
import com.easefun.polyv.livescenes.model.PolyvUploadTokenVO;
import com.easefun.polyv.livescenes.net.PolyvApiManager;
import com.plv.foundationsdk.log.PLVCommonLog;
import com.plv.foundationsdk.net.PLVRfProgressListener;
import com.plv.foundationsdk.rx.PLVRxBaseTransformer;
import com.plv.foundationsdk.utils.PLVAppUtils;
import com.plv.foundationsdk.utils.PLVSDCardUtils;
import com.plv.thirdpart.blankj.utilcode.util.EncryptUtils;
import com.plv.thirdpart.blankj.utilcode.util.ImageUtils;
import com.plv.thirdpart.blankj.utilcode.util.Utils;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import master.flame.danmaku.danmaku.util.IOUtils;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class PolyvSendChatImageHelper {
    private static final String TAG = "PolyvSendChatImageHelpe";
    private static final int ALLOW_LENGTH = 0x200000;
    private static final int WEBP_FILE_HEADER_SIZE = 12;
    private static final String WEBP_FILE_HEADER_RIFF = "RIFF";
    private static final String WEBP_FILE_HEADER_WEBP = "WEBP";

    public static void sendChatImage(final String string, final PolyvSendLocalImgEvent polyvSendLocalImgEvent, final PolyvSendChatImageListener polyvSendChatImageListener, final CompositeDisposable ... compositeDisposableArray) {
        final String string2 = polyvSendLocalImgEvent.getImageFilePath();
        final long l = System.currentTimeMillis();
        final String string3 = EncryptUtils.encryptMD5ToString((String)("upload_token_live" + string + l)).toLowerCase();
        final File file = new File(string2);
        final String[] stringArray = new String[1];
        final File file2 = PolyvSendChatImageHelper.createTmpFile(file);
        Disposable disposable = Observable.just((Object)1).map((Function)new Function<Integer, File>(){

            public File apply(Integer n) throws Exception {
                String string = ImageUtils.getImageType((File)file);
                if (string != null) {
                    stringArray[0] = string.toLowerCase();
                } else if (PolyvSendChatImageHelper.isWebPFile(new FileInputStream(file))) {
                    stringArray[0] = PolyvSendChatImageHelper.WEBP_FILE_HEADER_WEBP.toLowerCase();
                }
                if (!("jpg".equals(stringArray[0]) || "jpeg".equals(stringArray[0]) || "png".equals(stringArray[0]) || "gif".equals(stringArray[0]) || "webp".equals(stringArray[0]))) {
                    throw new Exception("\u56fe\u7247\u683c\u5f0f\u4e0d\u652f\u6301");
                }
                if (polyvSendLocalImgEvent.getHeight() > 500 || polyvSendLocalImgEvent.getWidth() > 500 && !"gif".equals(stringArray[0])) {
                    PolyvSendChatImageHelper.compressImage(file.getAbsolutePath(), file2.getAbsolutePath(), 100, true);
                    int[] nArray = PolyvSendChatImageHelper.getPictureWh(file2.getAbsolutePath());
                    polyvSendLocalImgEvent.setWidth(nArray[0]);
                    polyvSendLocalImgEvent.setHeight(nArray[1]);
                    return file2;
                }
                return file;
            }
        }).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<File>(){

            public void accept(final File file) throws Exception {
                if (file.length() > 0x200000L) {
                    long l2 = file.length() / 0x100000L;
                    final int n = l2 > 20L ? 20 : (l2 > 15L ? 30 : (l2 > 10L ? 40 : (l2 > 5L ? 55 : 70)));
                    if ("gif".equals(stringArray[0])) {
                        if (polyvSendChatImageListener != null) {
                            polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, new Exception("\u56fe\u7247\u8d44\u6e90\u8fc7\u5927"));
                        }
                        return;
                    }
                    Disposable disposable = Observable.just((Object)1).map((Function)new Function<Integer, Integer>(){

                        public Integer apply(Integer n2) throws Exception {
                            for (int i = n; i >= 0; i -= 8) {
                                PolyvSendChatImageHelper.compressImage(file.getAbsolutePath(), file2.getAbsolutePath(), i, false);
                                if (file2.length() < 0x200000L) break;
                            }
                            if (file2.length() > 0x200000L) {
                                throw new Exception("\u56fe\u7247\u8d44\u6e90\u592a\u5927");
                            }
                            return n2;
                        }
                    }).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<Integer>(){

                        public void accept(Integer n) throws Exception {
                            PolyvSendChatImageHelper.uploadImg(file2, string2, ImageUtils.getImageType((File)file2).toLowerCase(), l, string3, string, polyvSendLocalImgEvent, polyvSendChatImageListener, compositeDisposableArray);
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        public void accept(Throwable throwable) throws Exception {
                            if (polyvSendChatImageListener != null) {
                                polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, throwable);
                            }
                        }
                    });
                    if (compositeDisposableArray != null && compositeDisposableArray.length > 0) {
                        compositeDisposableArray[0].add(disposable);
                    }
                    return;
                }
                PolyvSendChatImageHelper.uploadImg(file, string2, stringArray[0], l, string3, string, polyvSendLocalImgEvent, polyvSendChatImageListener, compositeDisposableArray);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (polyvSendChatImageListener != null) {
                    polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, throwable);
                }
            }
        });
        if (compositeDisposableArray != null && compositeDisposableArray.length > 0) {
            compositeDisposableArray[0].add(disposable);
        }
    }

    private static void uploadImg(final File file, String string, String string2, final long l, String string3, String string4, final PolyvSendLocalImgEvent polyvSendLocalImgEvent, final PolyvSendChatImageListener polyvSendChatImageListener, final CompositeDisposable ... compositeDisposableArray) {
        final String string5 = file.getName().contains(".") ? string.substring(string.lastIndexOf(46)) : "." + string2;
        Disposable disposable = PolyvApiManager.getPolyvLiveStatusApi().getUploadToken(string4, l + "", string3).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<PolyvUploadTokenVO>(){

            public void accept(PolyvUploadTokenVO polyvUploadTokenVO) throws Exception {
                final String string = "chat_img_Android_" + l;
                final String string2 = polyvUploadTokenVO.getData().getDir() + string + string5;
                MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("key", string2).addFormDataPart("policy", polyvUploadTokenVO.getData().getPolicy()).addFormDataPart("OSSAccessKeyId", polyvUploadTokenVO.getData().getAccessid()).addFormDataPart("signature", polyvUploadTokenVO.getData().getSignature()).addFormDataPart("success_action_status", "200").addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file));
                MultipartBody multipartBody = builder.build();
                Disposable disposable = PolyvApiManager.getPolyvLiveImagesApi((RequestBody)multipartBody, new PLVRfProgressListener(){

                    public void onProgress(long l, long l2) {
                        if (polyvSendChatImageListener != null) {
                            polyvSendChatImageListener.onProgress(polyvSendLocalImgEvent, (float)l * 1.0f / (float)l2);
                        }
                    }
                }).uploadLiveImages((RequestBody)multipartBody).compose((ObservableTransformer)new PLVRxBaseTransformer()).subscribe((Consumer)new Consumer<ResponseBody>(){

                    public void accept(ResponseBody responseBody) throws Exception {
                        if (polyvSendChatImageListener != null) {
                            polyvSendChatImageListener.onSuccess(polyvSendLocalImgEvent, "https://liveimages.videocc.net/" + string2, string);
                        }
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) throws Exception {
                        if (polyvSendChatImageListener != null) {
                            polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, throwable);
                        }
                    }
                });
                if (compositeDisposableArray != null && compositeDisposableArray.length > 0) {
                    compositeDisposableArray[0].add(disposable);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (polyvSendChatImageListener != null) {
                    polyvSendChatImageListener.onUploadFail(polyvSendLocalImgEvent, throwable);
                }
            }
        });
        if (compositeDisposableArray != null && compositeDisposableArray.length > 0) {
            compositeDisposableArray[0].add(disposable);
        }
    }

    private static boolean isWebPFile(InputStream inputStream) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[12];
            if (inputStream.read(byArray, 0, 12) == 12) {
                bl = WEBP_FILE_HEADER_RIFF.equals(new String(byArray, 0, 4, "US-ASCII")) && WEBP_FILE_HEADER_WEBP.equals(new String(byArray, 8, 4, "US-ASCII"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return bl;
    }

    private static File createTmpFile(File file) {
        if (Build.VERSION.SDK_INT >= 29) {
            File file2 = new File(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/PolyvImg/tmp/" + file.getName());
            if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
                file2 = new File(file2.getParent(), "nc_" + file2.getName());
            }
            PLVSDCardUtils.createNoMediaFile((String)file2.getParent());
            return file2;
        }
        File file3 = new File(PLVSDCardUtils.createPath((Context)PLVAppUtils.getApp(), (String)"PolyvImg/tmp"), file.getName());
        if (file3.getAbsolutePath().equals(file.getAbsolutePath())) {
            file3 = new File(file3.getParent(), "nc_" + file3.getName());
        }
        PLVSDCardUtils.createNoMediaFile((String)file3.getParent());
        return file3;
    }

    public static Bitmap compressImage(String string) throws Exception {
        File file = new File(string);
        if (!file.isFile() || file.length() < 0x100000L) {
            return null;
        }
        long l = file.length() / 0x100000L;
        int n = l > 20L ? 20 : (l > 15L ? 30 : (l > 10L ? 40 : (l > 5L ? 55 : 70)));
        String string2 = PolyvSendChatImageHelper.createTmpFile(file).getAbsolutePath();
        PolyvSendChatImageHelper.compressImage(string, string2, n, true);
        return BitmapFactory.decodeFile((String)string2);
    }

    public static String compressImage(String string, String string2, int n, boolean bl) throws Exception {
        Bitmap bitmap = bl ? PolyvSendChatImageHelper.getSmallBitmap(string) : BitmapFactory.decodeFile((String)string);
        File file = new File(string2);
        try (FileOutputStream fileOutputStream = null;){
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            } else if (!file.delete()) {
                PLVCommonLog.d((String)TAG, (String)"delete outputFile fail");
                throw new Exception("delete  outputFile fail");
            }
            fileOutputStream = new FileOutputStream(file);
            boolean bl2 = bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)fileOutputStream);
            if (!bl2) {
                throw new Exception("compress fail");
            }
        }
        return file.getPath();
    }

    public static Bitmap getSmallBitmap(String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        options.inSampleSize = PolyvSendChatImageHelper.calculateInSampleSize(options, 500, 500);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
    }

    public static int readPictureDegree(String string) {
        int n = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int n) {
        if (bitmap != null) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)n);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return bitmap;
        }
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            int n6;
            int n7 = Math.round((float)n3 / (float)n2);
            n5 = n7 < (n6 = Math.round((float)n4 / (float)n)) ? n7 : n6;
        }
        return n5;
    }

    public static int[] getPictureWh(String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        int n = options.outHeight;
        int n2 = options.outWidth;
        return new int[]{n2, n};
    }
}

