package com.easefun.polyv.livescenes.video.api;

import com.easefun.polyv.businesssdk.model.video.PolyvMediaPlayMode;

/**
 * @author df
 * @create 2018/7/28
 * @Describe 云直播业务接口
 */
public interface IPolyvLiveVideoView {

    /**
     * 设置PPT在线播放
     *
     * @param userId    用户id
     * @param channelId 频道id
     * @param isPlayHls 是否播放hls视频，默认为false
     */
    public void setPPTLivePlay(String userId, String channelId, boolean isPlayHls);

    /**
     * 获取连麦得类型
     * “audio” 语音  “video” 视频
     * @return
     */
    public String getLinkMicType();


    /**
     * 更新主副屏切换按钮得状态
     * hasCamera:讲师是否打开摄像头
     */
    public void updateMainScreenStatus(boolean hasOpenCamera);

    /**
     * 设置媒体播放模式，默认为{@link PolyvMediaPlayMode#MODE_VIDEO}。
     *
     * @param mediaPlayMode {@link PolyvMediaPlayMode#MODE_AUDIO} or {@link PolyvMediaPlayMode#MODE_VIDEO}
     */
    void setMediaPlayMode(@PolyvMediaPlayMode.Mode int mediaPlayMode);

    /**
     * 获取当前的媒体播放模式
     *
     * @return {@link PolyvMediaPlayMode#MODE_AUDIO} or {@link PolyvMediaPlayMode#MODE_VIDEO}。如果没有设置，默认返回{@link PolyvMediaPlayMode#MODE_VIDEO}
     */
    int getMediaPlayMode();

    /**
     * 改变媒体播放模式
     *
     * @param mediaPlayMode {@link PolyvMediaPlayMode#MODE_AUDIO} or {@link PolyvMediaPlayMode#MODE_VIDEO}
     */
    void changeMediaPlayMode(@PolyvMediaPlayMode.Mode int mediaPlayMode);

    /**
     * 设置音频模式下的播放器画面，如果没有设置，切换到音频模式则播放器的画面是黑色背景。
     * @param view view
     */
    void setAudioModeView(IPolyvLiveAudioModeView view);

    /**
     * 设置追帧开关是否打开
     * 默认关闭
     */
    void enableFrameSkip(boolean enable);

    /**
     * rtc订阅成功
     */
    void rtcPrepared();
}
