/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

class AdditionalParamsProcessor {
    static Set<String> builtInParams(String ... params) {
        if (params == null || params.length == 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(params)));
    }

    static Map<String, String> checkAdditionalParams(@Nullable Map<String, String> params, @NonNull Set<String> builtInParams) {
        if (params == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> additionalParams = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Preconditions.checkNotNull(key, "additional parameter keys cannot be null");
            Preconditions.checkNotNull(value, "additional parameter values cannot be null");
            Preconditions.checkArgument(!builtInParams.contains(key), "Parameter %s is directly supported via the authorization request builder, use the builder method instead", key);
            additionalParams.put(key, value);
        }
        return Collections.unmodifiableMap(additionalParams);
    }

    static Map<String, String> extractAdditionalParams(JSONObject json, Set<String> builtInParams) throws JSONException {
        LinkedHashMap<String, String> additionalParams = new LinkedHashMap<String, String>();
        Iterator keysIter = json.keys();
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            if (builtInParams.contains(key)) continue;
            additionalParams.put(key, json.get(key).toString());
        }
        return additionalParams;
    }

    static Map<String, String> extractAdditionalParams(Uri uri, Set<String> builtInParams) {
        LinkedHashMap<String, String> additionalParams = new LinkedHashMap<String, String>();
        for (String param : uri.getQueryParameterNames()) {
            if (builtInParams.contains(param)) continue;
            additionalParams.put(param, uri.getQueryParameter(param));
        }
        return additionalParams;
    }

    private AdditionalParamsProcessor() {
    }
}

