/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AsciiStringListUtil;
import net.openid.appauth.Clock;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import net.openid.appauth.SystemClock;
import net.openid.appauth.TokenRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenResponse {
    public static final String TOKEN_TYPE_BEARER = "Bearer";
    @VisibleForTesting
    static final String KEY_REQUEST = "request";
    @VisibleForTesting
    static final String KEY_EXPIRES_AT = "expires_at";
    @VisibleForTesting
    static final String KEY_TOKEN_TYPE = "token_type";
    @VisibleForTesting
    static final String KEY_ACCESS_TOKEN = "access_token";
    @VisibleForTesting
    static final String KEY_EXPIRES_IN = "expires_in";
    @VisibleForTesting
    static final String KEY_REFRESH_TOKEN = "refresh_token";
    @VisibleForTesting
    static final String KEY_ID_TOKEN = "id_token";
    @VisibleForTesting
    static final String KEY_SCOPE = "scope";
    @VisibleForTesting
    static final String KEY_ADDITIONAL_PARAMETERS = "additionalParameters";
    private static final Set<String> BUILT_IN_PARAMS = new HashSet<String>(Arrays.asList("token_type", "access_token", "expires_in", "refresh_token", "id_token", "scope"));
    @NonNull
    public final TokenRequest request;
    @Nullable
    public final String tokenType;
    @Nullable
    public final String accessToken;
    @Nullable
    public final Long accessTokenExpirationTime;
    @Nullable
    public final String idToken;
    @Nullable
    public final String refreshToken;
    @Nullable
    public final String scope;
    @NonNull
    public final Map<String, String> additionalParameters;

    TokenResponse(@NonNull TokenRequest request, @Nullable String tokenType, @Nullable String accessToken, @Nullable Long accessTokenExpirationTime, @Nullable String idToken, @Nullable String refreshToken, @Nullable String scope, @NonNull Map<String, String> additionalParameters) {
        this.request = request;
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.accessTokenExpirationTime = accessTokenExpirationTime;
        this.idToken = idToken;
        this.refreshToken = refreshToken;
        this.scope = scope;
        this.additionalParameters = additionalParameters;
    }

    @Nullable
    public Set<String> getScopeSet() {
        return AsciiStringListUtil.stringToSet(this.scope);
    }

    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_REQUEST, this.request.jsonSerialize());
        JsonUtil.putIfNotNull(json, KEY_TOKEN_TYPE, this.tokenType);
        JsonUtil.putIfNotNull(json, KEY_ACCESS_TOKEN, this.accessToken);
        JsonUtil.putIfNotNull(json, KEY_EXPIRES_AT, this.accessTokenExpirationTime);
        JsonUtil.putIfNotNull(json, KEY_ID_TOKEN, this.idToken);
        JsonUtil.putIfNotNull(json, KEY_REFRESH_TOKEN, this.refreshToken);
        JsonUtil.putIfNotNull(json, KEY_SCOPE, this.scope);
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    @NonNull
    public static TokenResponse jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        if (!json.has(KEY_REQUEST)) {
            throw new IllegalArgumentException("token request not provided and not found in JSON");
        }
        return new Builder(TokenRequest.jsonDeserialize(json.getJSONObject(KEY_REQUEST))).setTokenType(JsonUtil.getStringIfDefined(json, KEY_TOKEN_TYPE)).setAccessToken(JsonUtil.getStringIfDefined(json, KEY_ACCESS_TOKEN)).setAccessTokenExpirationTime(JsonUtil.getLongIfDefined(json, KEY_EXPIRES_AT)).setIdToken(JsonUtil.getStringIfDefined(json, KEY_ID_TOKEN)).setRefreshToken(JsonUtil.getStringIfDefined(json, KEY_REFRESH_TOKEN)).setScope(JsonUtil.getStringIfDefined(json, KEY_SCOPE)).setAdditionalParameters(JsonUtil.getStringMap(json, KEY_ADDITIONAL_PARAMETERS)).build();
    }

    @NonNull
    public static TokenResponse jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotEmpty(jsonStr, "jsonStr cannot be null or empty");
        return TokenResponse.jsonDeserialize(new JSONObject(jsonStr));
    }

    public static final class Builder {
        @NonNull
        private TokenRequest mRequest;
        @Nullable
        private String mTokenType;
        @Nullable
        private String mAccessToken;
        @Nullable
        private Long mAccessTokenExpirationTime;
        @Nullable
        private String mIdToken;
        @Nullable
        private String mRefreshToken;
        @Nullable
        private String mScope;
        @NonNull
        private Map<String, String> mAdditionalParameters;

        public Builder(@NonNull TokenRequest request) {
            this.setRequest(request);
            this.mAdditionalParameters = Collections.emptyMap();
        }

        @NonNull
        public Builder fromResponseJsonString(@NonNull String jsonStr) throws JSONException {
            Preconditions.checkNotEmpty(jsonStr, "json cannot be null or empty");
            return this.fromResponseJson(new JSONObject(jsonStr));
        }

        @NonNull
        public Builder fromResponseJson(@NonNull JSONObject json) throws JSONException {
            this.setTokenType(JsonUtil.getString(json, TokenResponse.KEY_TOKEN_TYPE));
            this.setAccessToken(JsonUtil.getStringIfDefined(json, TokenResponse.KEY_ACCESS_TOKEN));
            this.setAccessTokenExpirationTime(JsonUtil.getLongIfDefined(json, TokenResponse.KEY_EXPIRES_AT));
            if (json.has(TokenResponse.KEY_EXPIRES_IN)) {
                this.setAccessTokenExpiresIn(json.getLong(TokenResponse.KEY_EXPIRES_IN));
            }
            this.setRefreshToken(JsonUtil.getStringIfDefined(json, TokenResponse.KEY_REFRESH_TOKEN));
            this.setIdToken(JsonUtil.getStringIfDefined(json, TokenResponse.KEY_ID_TOKEN));
            this.setScope(JsonUtil.getStringIfDefined(json, TokenResponse.KEY_SCOPE));
            this.setAdditionalParameters(AdditionalParamsProcessor.extractAdditionalParams(json, (Set<String>)BUILT_IN_PARAMS));
            return this;
        }

        @NonNull
        public Builder setRequest(@NonNull TokenRequest request) {
            this.mRequest = Preconditions.checkNotNull(request, "request cannot be null");
            return this;
        }

        @NonNull
        public Builder setTokenType(@Nullable String tokenType) {
            this.mTokenType = Preconditions.checkNullOrNotEmpty(tokenType, "token type must not be empty if defined");
            return this;
        }

        @NonNull
        public Builder setAccessToken(@Nullable String accessToken) {
            this.mAccessToken = Preconditions.checkNullOrNotEmpty(accessToken, "access token cannot be empty if specified");
            return this;
        }

        @NonNull
        public Builder setAccessTokenExpiresIn(@NonNull Long expiresIn) {
            return this.setAccessTokenExpiresIn(expiresIn, SystemClock.INSTANCE);
        }

        @NonNull
        @VisibleForTesting
        Builder setAccessTokenExpiresIn(@Nullable Long expiresIn, @NonNull Clock clock) {
            this.mAccessTokenExpirationTime = expiresIn == null ? null : Long.valueOf(clock.getCurrentTimeMillis() + TimeUnit.SECONDS.toMillis(expiresIn));
            return this;
        }

        @NonNull
        public Builder setAccessTokenExpirationTime(@Nullable Long expiresAt) {
            this.mAccessTokenExpirationTime = expiresAt;
            return this;
        }

        public Builder setIdToken(@Nullable String idToken) {
            this.mIdToken = Preconditions.checkNullOrNotEmpty(idToken, "id token must not be empty if defined");
            return this;
        }

        public Builder setRefreshToken(@Nullable String refreshToken) {
            this.mRefreshToken = Preconditions.checkNullOrNotEmpty(refreshToken, "refresh token must not be empty if defined");
            return this;
        }

        @NonNull
        public Builder setScope(@Nullable String scope) {
            if (TextUtils.isEmpty((CharSequence)scope)) {
                this.mScope = null;
            } else {
                this.setScopes(scope.split(" +"));
            }
            return this;
        }

        @NonNull
        public Builder setScopes(String ... scopes) {
            if (scopes == null) {
                scopes = new String[]{};
            }
            this.setScopes(Arrays.asList(scopes));
            return this;
        }

        @NonNull
        public Builder setScopes(@Nullable Iterable<String> scopes) {
            this.mScope = AsciiStringListUtil.iterableToString(scopes);
            return this;
        }

        @NonNull
        public Builder setAdditionalParameters(@Nullable Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        public TokenResponse build() {
            return new TokenResponse(this.mRequest, this.mTokenType, this.mAccessToken, this.mAccessTokenExpirationTime, this.mIdToken, this.mRefreshToken, this.mScope, this.mAdditionalParameters);
        }
    }
}

