/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public class EndSessionRequest
extends AuthorizationManagementRequest {
    private static final String PARAM_ID_TOKEN_HINT = "id_token_hint";
    private static final String PARAM_REDIRECT_URI = "post_logout_redirect_uri";
    private static final String PARAM_STATE = "state";
    private static final String KEY_CONFIGURATION = "configuration";
    @VisibleForTesting
    static final String KEY_ID_TOKEN_HINT = "id_token_hint";
    @VisibleForTesting
    static final String KEY_REDIRECT_URI = "post_logout_redirect_uri";
    @VisibleForTesting
    static final String KEY_STATE = "state";
    @NonNull
    public final AuthorizationServiceConfiguration configuration;
    @NonNull
    public final String idToken;
    @NonNull
    public final Uri redirectUri;
    @NonNull
    public final String state;

    @VisibleForTesting
    private EndSessionRequest(@NonNull AuthorizationServiceConfiguration configuration, @NonNull String idToken, @NonNull Uri redirectUri, @NonNull String state) {
        this.configuration = configuration;
        this.idToken = idToken;
        this.redirectUri = redirectUri;
        this.state = state;
    }

    @Override
    @NonNull
    public String getState() {
        return this.state;
    }

    @Override
    public Uri toUri() {
        Uri.Builder uriBuilder = this.configuration.endSessionEndpoint.buildUpon().appendQueryParameter("post_logout_redirect_uri", this.redirectUri.toString()).appendQueryParameter("id_token_hint", this.idToken).appendQueryParameter("state", this.state);
        return uriBuilder.build();
    }

    @Override
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_CONFIGURATION, this.configuration.toJson());
        JsonUtil.put(json, "id_token_hint", this.idToken);
        JsonUtil.put(json, "post_logout_redirect_uri", this.redirectUri.toString());
        JsonUtil.put(json, "state", this.state);
        return json;
    }

    public static EndSessionRequest jsonDeserialize(@NonNull JSONObject jsonObject) throws JSONException {
        Preconditions.checkNotNull(jsonObject, "json cannot be null");
        return new EndSessionRequest(AuthorizationServiceConfiguration.fromJson(jsonObject.getJSONObject(KEY_CONFIGURATION)), JsonUtil.getString(jsonObject, "id_token_hint"), JsonUtil.getUri(jsonObject, "post_logout_redirect_uri"), JsonUtil.getString(jsonObject, "state"));
    }

    @NonNull
    public static EndSessionRequest jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotNull(jsonStr, "json string cannot be null");
        return EndSessionRequest.jsonDeserialize(new JSONObject(jsonStr));
    }

    static boolean isEndSessionRequest(JSONObject json) {
        return json.has("post_logout_redirect_uri");
    }

    public static final class Builder {
        @NonNull
        private AuthorizationServiceConfiguration mConfiguration;
        @NonNull
        private String mIdToken;
        @NonNull
        private Uri mRedirectUri;
        @NonNull
        private String mState;

        public Builder(@NonNull AuthorizationServiceConfiguration configuration, @NonNull String idToken, @NonNull Uri redirectUri) {
            this.setAuthorizationServiceConfiguration(configuration);
            this.setIdToken(idToken);
            this.setRedirectUri(redirectUri);
            this.setState(AuthorizationManagementRequest.generateRandomState());
        }

        public Builder setAuthorizationServiceConfiguration(@NonNull AuthorizationServiceConfiguration configuration) {
            this.mConfiguration = Preconditions.checkNotNull(configuration, "configuration cannot be null");
            return this;
        }

        public Builder setIdToken(@NonNull String idToken) {
            this.mIdToken = Preconditions.checkNotEmpty(idToken, "idToken cannot be null or empty");
            return this;
        }

        public Builder setRedirectUri(@Nullable Uri redirectUri) {
            this.mRedirectUri = Preconditions.checkNotNull(redirectUri, "redirect Uri cannot be null");
            return this;
        }

        public Builder setState(@NonNull String state) {
            this.mState = Preconditions.checkNotEmpty(state, "state cannot be null or empty");
            return this;
        }

        @NonNull
        public EndSessionRequest build() {
            return new EndSessionRequest(this.mConfiguration, this.mIdToken, this.mRedirectUri, this.mState);
        }
    }
}

