/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.browser;

import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.Set;
import net.openid.appauth.browser.BrowserDescriptor;
import net.openid.appauth.browser.BrowserMatcher;
import net.openid.appauth.browser.Browsers;
import net.openid.appauth.browser.VersionRange;

public class VersionedBrowserMatcher
implements BrowserMatcher {
    public static final VersionedBrowserMatcher CHROME_CUSTOM_TAB = new VersionedBrowserMatcher("com.android.chrome", Browsers.Chrome.SIGNATURE_SET, true, VersionRange.atLeast(Browsers.Chrome.MINIMUM_VERSION_FOR_CUSTOM_TAB));
    public static final VersionedBrowserMatcher CHROME_BROWSER = new VersionedBrowserMatcher("com.android.chrome", Browsers.Chrome.SIGNATURE_SET, false, VersionRange.ANY_VERSION);
    public static final VersionedBrowserMatcher FIREFOX_BROWSER = new VersionedBrowserMatcher("org.mozilla.firefox", Browsers.Firefox.SIGNATURE_SET, false, VersionRange.ANY_VERSION);
    public static final VersionedBrowserMatcher SAMSUNG_BROWSER = new VersionedBrowserMatcher("com.sec.android.app.sbrowser", Browsers.SBrowser.SIGNATURE_SET, false, VersionRange.ANY_VERSION);
    public static final VersionedBrowserMatcher SAMSUNG_CUSTOM_TAB = new VersionedBrowserMatcher("com.sec.android.app.sbrowser", Browsers.SBrowser.SIGNATURE_SET, true, VersionRange.ANY_VERSION);
    private String mPackageName;
    private Set<String> mSignatureHashes;
    private VersionRange mVersionRange;
    private boolean mUsingCustomTab;

    public VersionedBrowserMatcher(@NonNull String packageName, @NonNull String signatureHash, boolean usingCustomTab, @NonNull VersionRange versionRange) {
        this(packageName, Collections.singleton(signatureHash), usingCustomTab, versionRange);
    }

    public VersionedBrowserMatcher(@NonNull String packageName, @NonNull Set<String> signatureHashes, boolean usingCustomTab, @NonNull VersionRange versionRange) {
        this.mPackageName = packageName;
        this.mSignatureHashes = signatureHashes;
        this.mUsingCustomTab = usingCustomTab;
        this.mVersionRange = versionRange;
    }

    @Override
    public boolean matches(@NonNull BrowserDescriptor descriptor) {
        return this.mPackageName.equals(descriptor.packageName) && this.mUsingCustomTab == descriptor.useCustomTab && this.mVersionRange.matches(descriptor.version) && this.mSignatureHashes.equals(descriptor.signatureHashes);
    }
}

