/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.hashing;

import java.nio.ByteOrder;
import net.openhft.hashing.Access;
import net.openhft.hashing.Primitives;

abstract class CharSequenceAccess
implements Access<CharSequence> {
    public static CharSequenceAccess charSequenceAccess(ByteOrder order) {
        return order == ByteOrder.LITTLE_ENDIAN ? LittleEndianCharSequenceAccess.INSTANCE : BigEndianCharSequenceAccess.INSTANCE;
    }

    public static CharSequenceAccess nativeCharSequenceAccess() {
        return CharSequenceAccess.charSequenceAccess(ByteOrder.nativeOrder());
    }

    private static int ix(long offset) {
        return (int)(offset >> 1);
    }

    static long getLong(CharSequence input, long offset, int char0Off, int char1Off, int char2Off, int char3Off) {
        int base = CharSequenceAccess.ix(offset);
        long char0 = input.charAt(base + char0Off);
        long char1 = input.charAt(base + char1Off);
        long char2 = input.charAt(base + char2Off);
        long char3 = input.charAt(base + char3Off);
        return char0 | char1 << 16 | char2 << 32 | char3 << 48;
    }

    static long getUnsignedInt(CharSequence input, long offset, int char0Off, int char1Off) {
        int base = CharSequenceAccess.ix(offset);
        long char0 = input.charAt(base + char0Off);
        long char1 = input.charAt(base + char1Off);
        return char0 | char1 << 16;
    }

    private CharSequenceAccess() {
    }

    @Override
    public int getInt(CharSequence input, long offset) {
        return (int)this.getUnsignedInt(input, offset);
    }

    @Override
    public int getUnsignedShort(CharSequence input, long offset) {
        return input.charAt(CharSequenceAccess.ix(offset));
    }

    @Override
    public int getShort(CharSequence input, long offset) {
        return (short)input.charAt(CharSequenceAccess.ix(offset));
    }

    static int getUnsignedByte(CharSequence input, long offset, int shift) {
        return Primitives.unsignedByte(input.charAt(CharSequenceAccess.ix(offset)) >> shift);
    }

    @Override
    public int getByte(CharSequence input, long offset) {
        return (byte)this.getUnsignedByte(input, offset);
    }

    private static class BigEndianCharSequenceAccess
    extends CharSequenceAccess {
        private static final CharSequenceAccess INSTANCE = new BigEndianCharSequenceAccess();

        private BigEndianCharSequenceAccess() {
        }

        @Override
        public long getLong(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getLong(input, offset, 3, 2, 1, 0);
        }

        @Override
        public long getUnsignedInt(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedInt(input, offset, 1, 0);
        }

        @Override
        public int getUnsignedByte(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedByte(input, offset, ((int)offset & 1 ^ 1) << 3);
        }

        @Override
        public ByteOrder byteOrder(CharSequence input) {
            return ByteOrder.BIG_ENDIAN;
        }
    }

    private static class LittleEndianCharSequenceAccess
    extends CharSequenceAccess {
        private static final CharSequenceAccess INSTANCE = new LittleEndianCharSequenceAccess();

        private LittleEndianCharSequenceAccess() {
        }

        @Override
        public long getLong(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getLong(input, offset, 0, 1, 2, 3);
        }

        @Override
        public long getUnsignedInt(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedInt(input, offset, 0, 1);
        }

        @Override
        public int getUnsignedByte(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedByte(input, offset, ((int)offset & 1) << 3);
        }

        @Override
        public ByteOrder byteOrder(CharSequence input) {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }
}

