/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import net.openhft.lang.model.DataValueGenerator;

class DataValueClassCache {
    private final DataValueGenerator dvg = new DataValueGenerator();

    DataValueClassCache() {
    }

    public <T> T newInstance(Class<T> interfaceClass) {
        try {
            return this.heapClassFor(interfaceClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T newDirectReference(Class<T> interfaceClass) {
        try {
            return this.directClassFor(interfaceClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized <T> Class<T> heapClassFor(Class<T> interfaceClass) {
        return this.dvg.acquireHeapClass(interfaceClass);
    }

    public synchronized <T> Class<T> directClassFor(Class<T> interfaceClass) {
        return this.dvg.acquireNativeClass(interfaceClass);
    }
}

