/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.Externalizable;
import java.io.IOException;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import org.jetbrains.annotations.NotNull;

public class ExternalizableMarshaller<E extends Externalizable>
implements BytesMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;

    public ExternalizableMarshaller(@NotNull Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
    }

    @Override
    public void write(Bytes bytes, @NotNull E e) {
        try {
            e.writeExternal(bytes);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E read(Bytes bytes) {
        Externalizable e;
        try {
            e = (Externalizable)NativeBytes.UNSAFE.allocateInstance(this.classMarshaled);
            e.readExternal(bytes);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
        return (E)e;
    }
}

