/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import net.openhft.compiler.CompilerUtils;
import net.openhft.compiler.JavaSourceFromString;
import org.jetbrains.annotations.NotNull;

public class CachedCompiler {
    private final File sourceDir;
    private final File classDir;

    public CachedCompiler(@NotNull File sourceDir, @NotNull File classDir) {
        this.sourceDir = sourceDir;
        this.classDir = classDir;
    }

    public static void close() {
        try {
            CompilerUtils.s_fileManager.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Class loadFromJava(@NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        return this.loadFromJava(this.getClass().getClassLoader(), className, javaCode);
    }

    @NotNull
    Map<String, byte[]> compileFromJava(@NotNull String className, @NotNull String javaCode) {
        Iterable<JavaFileObject> compilationUnits;
        if (this.sourceDir != null) {
            String filename = className.replaceAll("\\.", '\\' + File.separator) + ".java";
            File file = new File(this.sourceDir, filename);
            CompilerUtils.writeText(file, javaCode);
            compilationUnits = CompilerUtils.s_standardJavaFileManager.getJavaFileObjects(file);
        } else {
            compilationUnits = Collections.singletonList(new JavaSourceFromString(className, javaCode));
        }
        CompilerUtils.s_compiler.getTask(null, CompilerUtils.s_fileManager, null, null, null, compilationUnits).call();
        return CompilerUtils.s_fileManager.getAllBuffers();
    }

    public Class loadFromJava(@NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        for (Map.Entry<String, byte[]> entry : this.compileFromJava(className, javaCode).entrySet()) {
            String filename;
            boolean changed;
            String className2 = entry.getKey();
            byte[] bytes = entry.getValue();
            if (this.classDir != null && (changed = CompilerUtils.writeBytes(new File(this.classDir, filename = className2.replaceAll("\\.", '\\' + File.separator) + ".class"), bytes))) {
                Logger.getLogger(CachedCompiler.class.getName()).info("Updated " + className2 + " in " + this.classDir);
            }
            CompilerUtils.defineClass(classLoader, className2, bytes);
        }
        CompilerUtils.s_fileManager.clearBuffers();
        return classLoader.loadClass(className);
    }
}

