/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client;

import com.binance.api.client.BinanceApiAsyncRestClient;
import com.binance.api.client.BinanceApiRestClient;
import com.binance.api.client.BinanceApiWebSocketClient;
import com.binance.api.client.impl.BinanceApiAsyncRestClientImpl;
import com.binance.api.client.impl.BinanceApiRestClientImpl;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import com.binance.api.client.impl.BinanceApiWebSocketClientImpl;

public class BinanceApiClientFactory {
    private String apiKey;
    private String secret;

    private BinanceApiClientFactory(String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
    }

    public static BinanceApiClientFactory newInstance(String apiKey, String secret) {
        return new BinanceApiClientFactory(apiKey, secret);
    }

    public static BinanceApiClientFactory newInstance() {
        return new BinanceApiClientFactory(null, null);
    }

    public BinanceApiRestClient newRestClient() {
        return new BinanceApiRestClientImpl(this.apiKey, this.secret);
    }

    public BinanceApiAsyncRestClient newAsyncRestClient() {
        return new BinanceApiAsyncRestClientImpl(this.apiKey, this.secret);
    }

    public BinanceApiWebSocketClient newWebSocketClient() {
        return new BinanceApiWebSocketClientImpl(BinanceApiServiceGenerator.getSharedClient());
    }
}

