/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.channel.HostPortCfg;
import net.openhft.chronicle.wire.channel.impl.internal.Handler;

public class ChronicleChannelCfg<C extends ChronicleChannelCfg<C>>
extends SelfDescribingMarshallable {
    private boolean initiator;
    private boolean buffered;
    private PauserMode pauser = PauserMode.yielding;
    @Deprecated
    private String hostname;
    @Deprecated
    private int port;
    private double connectionTimeoutSecs = 1.0;
    private final Set<HostPortCfg> hostports = new LinkedHashSet<HostPortCfg>();

    public Set<HostPortCfg> hostPorts() {
        LinkedHashSet<HostPortCfg> result = new LinkedHashSet<HostPortCfg>();
        if (this.hostname != null) {
            result.add(new HostPortCfg(this.hostname, this.port));
        }
        result.addAll(this.hostports);
        return Collections.unmodifiableSet(result);
    }

    public C addHostnamePort(String hostname, int port) {
        this.hostports.add(new HostPortCfg(hostname, port));
        return (C)this;
    }

    public void removeHostnamePort(String hostname, int port) {
        this.hostports.remove(new HostPortCfg(hostname, port));
    }

    public C initiator(boolean initiator) {
        this.initiator = initiator;
        return (C)this;
    }

    public boolean initiator() {
        return this.initiator;
    }

    @Deprecated
    public String hostname() {
        return this.hostname;
    }

    @Deprecated
    public C hostname(String hostname) {
        this.hostname = hostname;
        return (C)this;
    }

    @Deprecated
    public int port() {
        return this.port;
    }

    @Deprecated
    public C port(int port) {
        this.port = port;
        return (C)this;
    }

    public boolean buffered() {
        return this.buffered;
    }

    public C buffered(boolean buffered) {
        this.buffered = buffered;
        return (C)this;
    }

    public PauserMode pauserMode() {
        return this.pauser;
    }

    public C pauserMode(PauserMode pauser) {
        this.pauser = pauser;
        return (C)this;
    }

    public double connectionTimeoutSecs() {
        if (this.connectionTimeoutSecs <= 0.0) {
            return Jvm.isDebug() ? 120.0 : 10.0;
        }
        return this.connectionTimeoutSecs;
    }

    public C connectionTimeoutSecs(double connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
        return (C)this;
    }

    public void clearHostnamePort() {
        this.hostports.clear();
    }

    static {
        Handler.init();
    }
}

