/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.openhft.chronicle.wire.utils.YamlAgitator;

public class DuplicateMessageAgitator
implements YamlAgitator {
    static final Pattern SEP = Pattern.compile("[.][.][.]\\s*");
    static final YamlAgitator INSTANCE = new DuplicateMessageAgitator(4);
    public static final String YAML_EOD = "...\n";
    private final int limit;

    public DuplicateMessageAgitator(int limit) {
        this.limit = limit;
    }

    @Override
    public Map<String, String> generateInputs(String yaml) {
        String[] messages = SEP.split(yaml, 0);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (int i = 0; i < messages.length && i < this.limit; ++i) {
            StringBuilder sb = new StringBuilder();
            String sep = yaml.endsWith(YAML_EOD) ? "" : (yaml.endsWith("...") ? "\n" : YAML_EOD);
            sb.append("=").append(yaml).append(sep).append(messages[i]).append(YAML_EOD);
            ret.put(sb.toString(), "msg-" + i + "-duplicated");
        }
        return ret;
    }
}

