/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.onoes.ChainedExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.InvocationTargetRuntimeException;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.YamlWire;
import net.openhft.chronicle.wire.utils.YamlAgitator;
import net.openhft.chronicle.wire.utils.YamlTester;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class TextMethodTester<T>
implements YamlTester {
    private static final boolean TESTS_INCLUDE_COMMENTS = Jvm.getBoolean((String)"tests.include.comments", (boolean)true);
    public static final boolean SINGLE_THREADED_CHECK_DISABLED = !Jvm.getBoolean((String)"yaml.tester.single.threaded.check.enabled", (boolean)false);
    private static final boolean DUMP_TESTS = Jvm.getBoolean((String)"dump.tests");
    public static final Consumer<InvocationTargetRuntimeException> DEFAULT_INVOCATION_TARGET_RUNTIME_EXCEPTION_CONSUMER = e -> Jvm.warn().on(TextMethodTester.class, "Exception calling target method. Continuing", (Throwable)e);
    private final String input;
    private final Class<T> outputClass;
    private final Set<Class> additionalOutputClasses = new LinkedHashSet<Class>();
    private final Function<WireOut, T> outputFunction;
    private final String output;
    private final BiFunction<T, UpdateInterceptor, Object> componentFunction;
    private final boolean TEXT_AS_YAML = Jvm.getBoolean((String)"wire.testAsYaml");
    private Function<T, ExceptionHandler> exceptionHandlerFunction;
    private BiConsumer<MethodReader, T> exceptionHandlerSetup;
    private String genericEvent;
    private List<String> setups;
    private Function<String, String> inputFunction;
    private Function<String, String> afterRun;
    private String expected;
    private String actual;
    private String[] retainLast;
    private MethodReaderInterceptorReturns methodReaderInterceptorReturns;
    private long timeoutMS = 25L;
    private UpdateInterceptor updateInterceptor;
    private Consumer<InvocationTargetRuntimeException> onInvocationException;
    private boolean exceptionHandlerFunctionAndLog;
    private Predicate<String> testFilter = s -> true;

    public TextMethodTester(String input, Function<T, Object> componentFunction, Class<T> outputClass, String output) {
        this(input, (T out, UpdateInterceptor ui) -> componentFunction.apply(out), outputClass, output);
    }

    public TextMethodTester(String input, BiFunction<T, UpdateInterceptor, Object> componentFunction, Class<T> outputClass, String output) {
        this(input, componentFunction, null, outputClass, output);
    }

    public TextMethodTester(String input, Function<T, Object> componentFunction, Function<WireOut, T> outputFunction, String output) {
        this(input, (out, ui) -> componentFunction.apply(out), outputFunction, null, output);
    }

    private TextMethodTester(String input, BiFunction<T, UpdateInterceptor, Object> componentFunction, Function<WireOut, T> outputFunction, Class<T> outputClass, String output) {
        this.input = input;
        this.componentFunction = componentFunction;
        this.outputFunction = outputFunction;
        this.outputClass = outputClass;
        this.output = output;
        this.setups = Collections.emptyList();
        this.onInvocationException = DEFAULT_INVOCATION_TARGET_RUNTIME_EXCEPTION_CONSUMER;
    }

    public TextMethodTester<T> addOutputClass(Class outputClass) {
        this.additionalOutputClasses.add(outputClass);
        return this;
    }

    public static boolean resourceExists(String resourceName) {
        try {
            return new File(resourceName).exists() || IOTools.urlFor(TextMethodTester.class, (String)resourceName) != null;
        }
        catch (FileNotFoundException ignored) {
            return false;
        }
    }

    public String[] retainLast() {
        return this.retainLast;
    }

    @NotNull
    public TextMethodTester<T> retainLast(String ... retainLast) {
        this.retainLast = retainLast;
        return this;
    }

    public String setup() {
        if (this.setups.size() != 1) {
            throw new IllegalStateException();
        }
        return this.setups.get(0);
    }

    @NotNull
    public TextMethodTester<T> setup(@Nullable String setup) {
        this.setups = setup == null ? Collections.emptyList() : Collections.singletonList(setup);
        return this;
    }

    @NotNull
    public TextMethodTester<T> setups(@NotNull List<String> setups) {
        this.setups = setups;
        return this;
    }

    public Function<String, String> afterRun() {
        return this.afterRun;
    }

    @NotNull
    public TextMethodTester<T> afterRun(Function<String, String> afterRun) {
        this.afterRun = afterRun;
        return this;
    }

    public BiConsumer<MethodReader, T> exceptionHandlerSetup() {
        return this.exceptionHandlerSetup;
    }

    public TextMethodTester<T> exceptionHandlerSetup(BiConsumer<MethodReader, T> exceptionHandlerSetup) {
        this.exceptionHandlerSetup = exceptionHandlerSetup;
        return this;
    }

    public String genericEvent() {
        return this.genericEvent;
    }

    public TextMethodTester<T> genericEvent(String genericEvent) {
        this.genericEvent = genericEvent;
        return this;
    }

    public Consumer<InvocationTargetRuntimeException> onInvocationException() {
        return this.onInvocationException;
    }

    public TextMethodTester<T> onInvocationException(Consumer<InvocationTargetRuntimeException> onInvocationException) {
        this.onInvocationException = onInvocationException;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TextMethodTester<T> run() throws IOException {
        Object[] objectArray;
        Object writer0;
        OnHeapBytes b = Bytes.allocateElasticOnHeap();
        b.singleThreadedCheckDisabled(SINGLE_THREADED_CHECK_DISABLED);
        Wire wireOut = this.createWire((Bytes<?>)b);
        if (this.outputClass != null) {
            MethodWriterBuilder<T> methodWriterBuilder = wireOut.methodWriterBuilder(this.outputClass);
            this.additionalOutputClasses.forEach(((VanillaMethodWriterBuilder)methodWriterBuilder)::addInterface);
            if (this.updateInterceptor != null) {
                methodWriterBuilder.updateInterceptor(this.updateInterceptor);
            }
            if (this.genericEvent != null) {
                methodWriterBuilder.genericEvent(this.genericEvent);
            }
            writer0 = methodWriterBuilder.get();
        } else {
            writer0 = this.outputFunction.apply(wireOut);
        }
        T writer = this.retainLast == null ? writer0 : this.cachedMethodWriter(writer0);
        Object component = this.componentFunction.apply(writer, this.updateInterceptor);
        if (component instanceof Object[]) {
            objectArray = (Object[])component;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = component;
        }
        Object[] components = objectArray;
        String setupNotFound = "";
        Class<Object> clazz = this.outputClass == null ? this.getClass() : this.outputClass;
        for (String setup : this.setups) {
            try {
                byte[] setupBytes = IOTools.readFile(clazz, (String)setup);
                Wire wire0 = this.createWire(setupBytes);
                MethodReader reader0 = wire0.methodReaderBuilder().methodReaderInterceptorReturns(this.methodReaderInterceptorReturns).warnMissing(true).build(components);
                while (this.readOne(reader0, null)) {
                    wireOut.bytes().clear();
                }
                wireOut.bytes().clear();
            }
            catch (FileNotFoundException ignored) {
                setupNotFound = setup + " not found";
            }
        }
        if (component instanceof PostSetup) {
            ((PostSetup)component).postSetup();
        }
        if (DUMP_TESTS) {
            System.out.println("input: " + this.input);
        }
        byte[] inputBytes = this.input.startsWith("=") ? this.input.substring(1).trim().getBytes() : IOTools.readFile(clazz, (String)this.input);
        Wire wire = this.createWire(inputBytes);
        if (TESTS_INCLUDE_COMMENTS) {
            wire.commentListener(wireOut::writeComment);
        }
        if (this.retainLast == null) {
            if (REGRESS_TESTS) {
                this.expected = "";
            } else {
                String outStr = this.output.startsWith("=") ? this.output.substring(1) : new String(IOTools.readFile(clazz, (String)this.output), StandardCharsets.ISO_8859_1);
                this.expected = outStr.trim().replace("\r", "");
            }
        } else {
            ValidatableUtil.startValidateDisabled();
            try {
                this.expected = this.loadLastValues().toString().trim();
            }
            finally {
                ValidatableUtil.endValidateDisabled();
            }
        }
        String originalExpected = this.expected;
        boolean[] sepOnNext = new boolean[]{true};
        ExceptionHandler exceptionHandler = null;
        ExceptionHandler warn = Jvm.warn();
        ExceptionHandler error = Jvm.error();
        ExceptionHandler debug = Jvm.debug();
        if (this.exceptionHandlerFunction != null) {
            exceptionHandler = this.createExceptionHandler(writer0, warn, error);
        }
        MethodReader reader = wire.methodReaderBuilder().methodReaderInterceptorReturns((m, o, args, invocation) -> {
            if (sepOnNext[0]) {
                wireOut.bytes().append((CharSequence)"---\n");
            }
            boolean bl = sepOnNext[0] = !m.getReturnType().isInterface();
            if (this.methodReaderInterceptorReturns == null) {
                return invocation.invoke(m, o, args);
            }
            return this.methodReaderInterceptorReturns.intercept(m, o, args, invocation);
        }).warnMissing(true).build(components);
        if (this.exceptionHandlerSetup != null) {
            this.exceptionHandlerSetup.accept(reader, (MethodReader)writer);
        }
        long pos = -1L;
        boolean ok = false;
        try {
            while (this.readOne(reader, exceptionHandler)) {
                int last;
                if (pos == wire.bytes().readPosition()) {
                    Jvm.warn().on(this.getClass(), "Bailing out of malformed message");
                    break;
                }
                Bytes<?> bytes2 = wireOut.bytes();
                if (this.retainLast == null && bytes2.writePosition() > 0L && (last = bytes2.peekUnsignedByte(bytes2.writePosition() - 1L)) >= 32) {
                    bytes2.append('\n');
                }
                pos = bytes2.readPosition();
            }
            ok = true;
        }
        finally {
            if (this.exceptionHandlerFunction != null) {
                Jvm.setExceptionHandlers((ExceptionHandler)error, (ExceptionHandler)warn, (ExceptionHandler)debug);
            }
            if (!ok) {
                System.err.println("Unable to parse\n" + new String(inputBytes, StandardCharsets.UTF_8));
            }
        }
        if (this.retainLast != null) {
            wireOut.bytes().clear();
        }
        if (this.retainLast != null) {
            CachedInvocationHandler invocationHandler = (CachedInvocationHandler)Proxy.getInvocationHandler(writer);
            try {
                invocationHandler.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        Closeable.closeQuietly((Object[])components);
        this.actual = wireOut.toString().trim();
        if (REGRESS_TESTS && !this.output.startsWith("=")) {
            Jvm.pause((long)100L);
            this.expected = this.actual = wireOut.toString().trim();
        } else {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + this.timeoutMS && this.actual.length() < this.expected.length()) {
                Jvm.pause((long)25L);
                this.actual = wireOut.toString().trim();
            }
        }
        if (this.afterRun != null) {
            this.expected = this.afterRun.apply(this.expected);
            this.actual = this.afterRun.apply(this.actual);
        }
        if (OS.isWindows()) {
            this.expected = this.expected.replace("\r\n", "\n");
            this.actual = this.actual.replace("\r\n", "\n");
        }
        if (REGRESS_TESTS && !originalExpected.equals(this.expected)) {
            this.updateOutput();
        }
        if (!this.expected.trim().equals(this.actual.trim()) && !setupNotFound.isEmpty()) {
            Jvm.warn().on(this.getClass(), setupNotFound);
        }
        return this;
    }

    private void updateOutput() throws IOException {
        String actual2;
        String output2;
        String output = this.replaceTargetWithSource(this.output);
        try {
            output2 = BytesUtil.findFile((String)output);
        }
        catch (FileNotFoundException fnfe) {
            File out2 = new File(this.output);
            File out = new File(out2.getParentFile(), "out.yaml");
            try {
                String output2dir = BytesUtil.findFile((String)this.replaceTargetWithSource(out.getPath()));
                output2 = new File(new File(output2dir).getParentFile(), out2.getName()).getPath();
            }
            catch (FileNotFoundException e2) {
                throw fnfe;
            }
        }
        String string = actual2 = this.actual.endsWith("\n") ? this.actual : this.actual + "\n";
        if (!this.testFilter.test(actual2)) {
            System.err.println("The expected output for " + output2 + " has been drops as it is too similar to previous results");
            return;
        }
        System.err.println("The expected output for " + output2 + " has been updated, check your commits");
        try (FileWriter fw = new FileWriter(output2);){
            if (OS.isWindows()) {
                actual2 = actual2.replace("\n", "\r\n");
            }
            fw.write(actual2);
        }
    }

    private ExceptionHandler createExceptionHandler(T writer0, ExceptionHandler warn, ExceptionHandler error) {
        ExceptionHandler exceptionHandler = this.exceptionHandlerFunction.apply(writer0);
        if (this.exceptionHandlerFunctionAndLog) {
            if (this.onInvocationException == DEFAULT_INVOCATION_TARGET_RUNTIME_EXCEPTION_CONSUMER) {
                ChainedExceptionHandler eh2 = new ChainedExceptionHandler(new ExceptionHandler[]{error, exceptionHandler});
                Consumer<InvocationTargetRuntimeException> invocationException = er -> eh2.on(LoggerFactory.getLogger((String)TextMethodTester.classNameFor(er.getCause())), "Unhandled Exception", er.getCause());
                this.onInvocationException = invocationException;
            }
            Jvm.setExceptionHandlers((ExceptionHandler)new ChainedExceptionHandler(new ExceptionHandler[]{error, exceptionHandler}), (ExceptionHandler)new ChainedExceptionHandler(new ExceptionHandler[]{warn, exceptionHandler}), null);
        } else {
            if (this.onInvocationException == DEFAULT_INVOCATION_TARGET_RUNTIME_EXCEPTION_CONSUMER) {
                ExceptionHandler eh = exceptionHandler;
                Consumer<InvocationTargetRuntimeException> invocationException = er -> eh.on(LoggerFactory.getLogger((String)TextMethodTester.classNameFor(er.getCause())), "Unhandled Exception", er.getCause());
                this.onInvocationException = invocationException;
            }
            Jvm.setExceptionHandlers((ExceptionHandler)exceptionHandler, (ExceptionHandler)exceptionHandler, null);
        }
        return exceptionHandler;
    }

    @Override
    public Map<String, String> agitate(YamlAgitator agitator) throws IORuntimeException {
        try {
            Class<Object> clazz = this.outputClass == null ? this.getClass() : this.outputClass;
            String yaml = this.input.startsWith("=") ? this.input.substring(1) : new String(IOTools.readFile(clazz, (String)this.input), StandardCharsets.UTF_8);
            return agitator.generateInputs(yaml);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public boolean readOne(MethodReader reader0, ExceptionHandler exceptionHandler) {
        try {
            return reader0.readOne();
        }
        catch (InvocationTargetRuntimeException e) {
            this.onInvocationException.accept(e);
        }
        catch (Throwable t) {
            if (exceptionHandler == null) {
                throw t;
            }
            exceptionHandler.on(LoggerFactory.getLogger((String)TextMethodTester.classNameFor(t)), t.toString());
        }
        return true;
    }

    @NotNull
    private static String classNameFor(Throwable t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        return stackTrace.length == 0 ? "TextMethodTester" : stackTrace[0].getClassName();
    }

    private String replaceTargetWithSource(String replace) {
        return replace.replace('\\', '/').replace("/target/test-classes/", "/src/test/resources/");
    }

    protected Wire createWire(byte[] byteArray) {
        Bytes bytes = this.inputFunction == null ? Bytes.wrapForRead((byte[])byteArray) : Bytes.from((String)this.inputFunction.apply(new String(byteArray, StandardCharsets.ISO_8859_1)));
        return this.createWire(bytes);
    }

    protected Wire createWire(Bytes<?> bytes) {
        return this.TEXT_AS_YAML ? new YamlWire(bytes).useTextDocuments().addTimeStamps(true) : new TextWire(bytes).useTextDocuments().addTimeStamps(true);
    }

    @NotNull
    protected StringBuilder loadLastValues() throws IOException, InvalidMarshallableException {
        Wire wireOut = this.createWire(BytesUtil.readFile((String)this.output));
        TreeMap<String, String> events = new TreeMap<String, String>();
        this.consumeDocumentSeparator(wireOut);
        while (wireOut.hasMore()) {
            StringBuilder event = new StringBuilder();
            long start = wireOut.bytes().readPosition();
            Map<String, Object> m = wireOut.read(event).marshallableAsMap(String.class, Object.class);
            assert (m != null);
            StringBuilder key = new StringBuilder(event);
            for (String s : this.retainLast) {
                key.append(",").append(m.get(s));
            }
            long end = wireOut.bytes().readPosition();
            BytesStore bytesStore = wireOut.bytes().subBytes(start, end - start);
            events.put(key.toString(), bytesStore.toString().trim());
            bytesStore.releaseLast();
            this.consumeDocumentSeparator(wireOut);
        }
        StringBuilder expected2 = new StringBuilder();
        for (String s : events.values()) {
            expected2.append(s.replace("\r", "")).append("\n");
        }
        return expected2;
    }

    private void consumeDocumentSeparator(@NotNull Wire wireOut) {
        if (wireOut.bytes().peekUnsignedByte() == 45) {
            wireOut.bytes().readSkip(3L);
        }
    }

    @NotNull
    private T cachedMethodWriter(T writer0) {
        Class[] interfaces = new Class[]{this.outputClass};
        return (T)Proxy.newProxyInstance(this.outputClass.getClassLoader(), interfaces, (InvocationHandler)new CachedInvocationHandler(writer0));
    }

    @Override
    public String expected() {
        if (this.expected == null) {
            try {
                this.run();
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
        return this.expected;
    }

    @Override
    public String actual() {
        if (this.actual == null) {
            try {
                this.run();
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
        return this.actual;
    }

    public TextMethodTester<T> updateInterceptor(UpdateInterceptor updateInterceptor) {
        this.updateInterceptor = updateInterceptor;
        return this;
    }

    public TextMethodTester<T> methodReaderInterceptorReturns(MethodReaderInterceptorReturns methodReaderInterceptorReturns) {
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        return this;
    }

    public TextMethodTester<T> timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    public TextMethodTester<T> exceptionHandlerFunction(Function<T, ExceptionHandler> exceptionHandlerFunction) {
        this.exceptionHandlerFunction = exceptionHandlerFunction;
        return this;
    }

    public TextMethodTester<T> exceptionHandlerFunctionAndLog(boolean exceptionHandlerFunctionAndLog) {
        this.exceptionHandlerFunctionAndLog = exceptionHandlerFunctionAndLog;
        return this;
    }

    public TextMethodTester<T> testFilter(Predicate<String> testFilter) {
        this.testFilter = testFilter;
        return this;
    }

    public TextMethodTester<T> inputFunction(Function<String, String> inputFunction) {
        this.inputFunction = inputFunction;
        return this;
    }

    @Deprecated
    class CachedInvocationHandler
    implements InvocationHandler {
        private final Map<String, Invocation> cache = new TreeMap<String, Invocation>();
        private final T writer0;

        public CachedInvocationHandler(T writer0) {
            this.writer0 = writer0;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, @NotNull Method method, @Nullable Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (args != null && args.length == 1 && args[0] instanceof Marshallable) {
                StringBuilder key = new StringBuilder();
                key.append(method.getName());
                Marshallable m = (Marshallable)args[0];
                try {
                    for (String s : TextMethodTester.this.retainLast) {
                        key.append(",").append(m.getField(s, Object.class));
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                args[0] = m.deepCopy();
                this.cache.put(key.toString(), new Invocation(method, args));
            } else {
                method.invoke(this.writer0, args);
            }
            return null;
        }

        public void flush() throws InvocationTargetException, IllegalAccessException {
            for (Invocation invocation : this.cache.values()) {
                invocation.method.invoke(this.writer0, invocation.args);
            }
        }
    }

    @Deprecated
    static class Invocation {
        Method method;
        Object[] args;

        public Invocation(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }
    }

    public static interface PostSetup {
        public void postSetup();
    }
}

