/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class WireTypeConverterInternal {
    private final Bytes bytes = Bytes.allocateElasticOnHeap();
    private final Wire yamlWire = (Wire)WireType.YAML_ONLY.apply(this.bytes);
    private final Wire jsonWire = (Wire)WireType.JSON_ONLY.apply(this.bytes);
    private Exception e;

    public WireTypeConverterInternal() {
        this.replaceClassLookup(this.jsonWire);
        this.replaceClassLookup(this.yamlWire);
    }

    public CharSequence jsonToYaml(CharSequence json) throws Exception {
        this.e = null;
        this.jsonWire.reset();
        this.jsonWire.bytes().append(json);
        Object object = this.jsonWire.getValueIn().object();
        if (this.e != null) {
            throw this.e;
        }
        this.yamlWire.reset();
        this.yamlWire.getValueOut().object(object);
        if (this.e != null) {
            throw this.e;
        }
        return this.yamlWire.bytes();
    }

    public CharSequence yamlToJson(CharSequence yaml) throws Exception {
        this.e = null;
        this.yamlWire.reset();
        this.yamlWire.bytes().clear().append(yaml);
        Object object = this.yamlWire.getValueIn().object();
        if (this.e != null) {
            throw this.e;
        }
        this.jsonWire.reset();
        this.jsonWire.bytes().clear();
        this.jsonWire.getValueOut().object(object);
        if (this.e != null) {
            throw this.e;
        }
        return this.jsonWire.bytes();
    }

    private void replaceClassLookup(Wire wire) {
        final ClassLookup delegate = wire.classLookup();
        wire.classLookup(new ClassLookup(){

            public Class<?> forName(CharSequence name) throws ClassNotFoundRuntimeException {
                try {
                    return delegate.forName(name);
                }
                catch (Exception e) {
                    WireTypeConverterInternal.this.e = e;
                    throw e;
                }
            }

            public String nameFor(Class<?> clazz) throws IllegalArgumentException {
                try {
                    return delegate.nameFor(clazz);
                }
                catch (Exception e) {
                    WireTypeConverterInternal.this.e = e;
                    throw e;
                }
            }

            public void addAlias(Class<?> ... classes) {
                delegate.addAlias((Class[])classes);
            }

            public void addAlias(Class<?> clazz, String names) {
                delegate.addAlias(clazz, names);
            }
        });
    }

    public void addAlias(Class newClass, String oldTypeName) {
        this.jsonWire.classLookup().addAlias(newClass, oldTypeName);
        this.yamlWire.classLookup().addAlias(newClass, oldTypeName);
    }
}

