/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireCommon;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontChain
public interface WireIn
extends WireCommon,
MarshallableIn {
    @NotNull
    default public <K, V> Map<K, V> readAllAsMap(Class<K> kClass, @NotNull Class<V> vClass, @NotNull Map<K, V> map) {
        while (this.isNotEmptyAfterPadding()) {
            long len = this.bytes().readRemaining();
            K k = this.readEvent(kClass);
            @Nullable V v = this.getValueIn().object(vClass);
            if (len == this.bytes().readRemaining()) break;
            map.put(k, v);
        }
        return map;
    }

    public void copyTo(@NotNull WireOut var1);

    @NotNull
    public ValueIn read();

    @NotNull
    public ValueIn read(@NotNull WireKey var1);

    @NotNull
    default public ValueIn read(String fieldName) {
        return this.read(() -> fieldName);
    }

    public long readEventNumber();

    @NotNull
    default public ValueIn readEventName(@NotNull StringBuilder name) {
        try {
            return this.read(name);
        }
        catch (Exception e) {
            throw new IORuntimeException("failed to parse bytes=" + this.bytes().toDebugString(128L), (Throwable)e);
        }
    }

    @NotNull
    public ValueIn read(@NotNull StringBuilder var1);

    @Nullable
    public <K> K readEvent(Class<K> var1);

    @NotNull
    public ValueIn getValueIn();

    public ObjectInput objectInput();

    @NotNull
    public WireIn readComment(@NotNull StringBuilder var1);

    @Override
    public void clear();

    default public boolean hasMore() {
        return this.isNotEmptyAfterPadding();
    }

    default public boolean isNotEmptyAfterPadding() {
        this.consumePadding();
        return !this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.bytes().isEmpty();
    }

    @NotNull
    default public WireIn readAlignTo(int alignment) {
        return this;
    }

    default public boolean readDocument(@Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) {
        return WireInternal.readData(this, metaDataConsumer, dataConsumer);
    }

    default public boolean readDocument(long position, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) {
        return WireInternal.readData(position, this, metaDataConsumer, dataConsumer);
    }

    default public void rawReadData(@NotNull ReadMarshallable marshallable) {
        WireInternal.rawReadData(this, marshallable);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument();

    public DocumentContext readingDocument(long var1);

    public void consumePadding();

    public void commentListener(Consumer<CharSequence> var1);

    default public boolean readDataHeader() throws EOFException {
        return this.readDataHeader(false) == HeaderType.DATA;
    }

    @NotNull
    public HeaderType readDataHeader(boolean var1) throws EOFException;

    public void readAndSetLength(long var1);

    public void readFirstHeader(long var1, TimeUnit var3) throws TimeoutException, StreamCorruptedException;

    public void readFirstHeader() throws StreamCorruptedException;

    public void readMetaDataHeader();

    @Deprecated
    @Nullable
    default public CharSequence asText() {
        return Wires.asText(this);
    }

    public String readingPeekYaml();

    default public void startEvent() {
    }

    default public boolean isEndEvent() {
        return false;
    }

    default public void endEvent() {
    }

    default public boolean hintReadInputOrder() {
        return false;
    }

    default public boolean hasMetaDataPrefix() {
        return false;
    }

    public static enum HeaderType {
        NONE,
        DATA,
        META_DATA,
        EOF;

    }
}

