/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.utils.JsonSourceCodeFormatter;

public class GenerateJsonSchemaMain {
    final Map<Class<?>, String> aliases = new LinkedHashMap();
    final Map<Class<?>, String> definitions = new LinkedHashMap();
    final Map<String, String> events = new LinkedHashMap<String, String>();
    final Set<Class<?>> eventClasses = new LinkedHashSet();

    public GenerateJsonSchemaMain() {
        this.aliases.put(Void.TYPE, "null");
        this.aliases.put(Void.class, "null");
        this.aliases.put(String.class, "string");
        this.aliases.put(Byte.TYPE, "integer");
        this.aliases.put(Short.TYPE, "integer");
        this.aliases.put(Integer.TYPE, "integer");
        this.aliases.put(Long.TYPE, "integer");
        this.aliases.put(Float.TYPE, "number");
        this.aliases.put(Double.TYPE, "number");
        this.aliases.put(Boolean.TYPE, "boolean");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String ... args) throws ClassNotFoundException {
        void var4_6;
        LinkedHashSet interfaces = new LinkedHashSet();
        String[] stringArray = args;
        int n = stringArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            String arg = stringArray[var4_6];
            interfaces.add(Class.forName(arg));
            ++var4_6;
        }
        GenerateJsonSchemaMain g = new GenerateJsonSchemaMain();
        for (Class clazz : interfaces) {
            g.generateEventSchemaFor(clazz);
        }
        System.out.println(g.asJson());
    }

    String asJson() {
        JsonSourceCodeFormatter sb = new JsonSourceCodeFormatter();
        String str = "{\n\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n\"$id\": \"http://json-schema.org/draft-07/schema#\",\n\"title\": \"Core schema meta-schema\",\n\"definitions\": {\n";
        sb.append(str);
        String sep = "";
        for (Map.Entry<Class<?>, String> entry : this.definitions.entrySet()) {
            sb.append(sep);
            sb.append("\"" + entry.getKey().getSimpleName() + "\": {\n");
            sb.append(entry.getValue());
            sb.append("}");
            sep = ",\n";
        }
        sb.append("\n");
        sb.append("},\n\"properties\": {\n");
        for (Map.Entry<Object, String> entry : this.events.entrySet()) {
            sb.append("\"" + (String)entry.getKey() + "\": {\n");
            sb.append(entry.getValue());
            sb.append("},\n");
        }
        sb.append("}\n}\n");
        return sb.toString();
    }

    void generateEventSchemaFor(Class<?> type) {
        if (type.isArray()) {
            return;
        }
        if (!this.eventClasses.add(type)) {
            return;
        }
        for (Method method : type.getMethods()) {
            this.generateEventSchemaFor(method.getReturnType());
            Stream.of(method.getParameterTypes()).forEach(this::generateObjectSchemaFor);
            StringBuilder desc = new StringBuilder();
            Class<?>[] pTypes = method.getParameterTypes();
            Annotation[][] pAnnotations = method.getParameterAnnotations();
            switch (pTypes.length) {
                case 0: {
                    desc.append("\"type\": \"constant\",\n\"value\": \"\"");
                    break;
                }
                case 1: {
                    this.generateMethodDesc(desc, pTypes[0], pAnnotations[0]);
                    break;
                }
                default: {
                    Jvm.debug().on(this.getClass(), "Method ignored as more than 1 argument " + method);
                }
            }
            this.events.put(method.getName(), desc.toString());
        }
    }

    private void addProperties(Map<String, String> properties, StringBuilder sb) {
        sb.append("\"properties\": {");
        String sep = "\n";
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            sb.append(sep);
            sb.append("\"" + entry.getKey() + "\": {\n");
            sb.append(entry.getValue());
            sb.append("}");
            sep = ",\n";
        }
        sb.append("\n}\n");
    }

    void generateObjectSchemaFor(Class<?> type) {
        Comment comment;
        if (type.isArray()) {
            return;
        }
        if (this.aliases.containsKey(type)) {
            return;
        }
        this.aliases.put(type, "#/definitions/" + type.getSimpleName());
        LinkedHashSet<String> required = new LinkedHashSet<String>();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        WireMarshaller.getAllField(type, fieldMap);
        for (Map.Entry entry : fieldMap.entrySet()) {
            String name = (String)entry.getKey();
            StringBuilder desc = new StringBuilder();
            Field field = (Field)entry.getValue();
            Class<?> fType = field.getType();
            Annotation[] annotations = field.getAnnotations();
            this.addTypeForFieldOrParam(desc, fType, annotations);
            if (fType.isPrimitive() || this.hasNotNull(annotations)) {
                required.add(name);
            }
            properties.put(name, desc.toString());
        }
        sb.append("\"type\": \"object\",\n");
        if (!required.isEmpty()) {
            sb.append("\"required\": [\n");
            sb.append(required.stream().map(s -> '\"' + s + '\"').collect(Collectors.joining(",\n")));
            sb.append("\n],\n");
        }
        if ((comment = type.getAnnotation(Comment.class)) != null) {
            sb.append("\"description\": \"" + comment.value() + "\",\n");
        }
        this.addProperties(properties, sb);
        this.definitions.put(type, sb.toString());
    }

    private boolean hasNotNull(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().endsWith(".NotNull")) continue;
            return true;
        }
        return false;
    }

    private void generateMethodDesc(StringBuilder desc, Class<?> pType, Annotation[] annotations) {
        this.addTypeForFieldOrParam(desc, pType, annotations);
    }

    private void addTypeForFieldOrParam(StringBuilder desc, Class<?> pType, Annotation[] annotations) {
        IntConversion ic = this.find(annotations, IntConversion.class);
        if (ic != null) {
            desc.append("\"type\": \"string\"\n");
        } else {
            LongConversion lc = this.find(annotations, LongConversion.class);
            if (lc != null) {
                Class<?> value = lc.value();
                if (value.getName().contains("Timestamp")) {
                    desc.append("\"type\": \"string\",\n\"format\": \"date-time\"");
                } else {
                    desc.append("\"type\": \"string\"\n");
                }
            } else if (Collection.class.isAssignableFrom(pType)) {
                desc.append("\"type\": \"array\"\n");
            } else if (Map.class.isAssignableFrom(pType)) {
                desc.append("\"type\": \"object\"\n");
            } else {
                this.generateObjectSchemaFor(pType);
                String alias = this.aliases.get(pType);
                String key = alias.startsWith("#") ? "$ref" : "type";
                desc.append("\"" + key + "\": \"" + alias + "\"\n");
            }
        }
    }

    private <T extends Annotation> T find(Annotation[] annotations, Class<T> aClass) {
        for (Annotation annotation : annotations) {
            if (!aClass.isAssignableFrom(annotation.annotationType())) continue;
            return (T)annotation;
        }
        return null;
    }
}

