/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.Base32IntConverter;
import net.openhft.chronicle.wire.LongConverter;

public class Base32LongConverter
implements LongConverter {
    public static final int MAX_LENGTH = LongConverter.maxParseLength(32);
    public static final Base32LongConverter INSTANCE = new Base32LongConverter();

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            byte b = Base32IntConverter.ENCODE[text.charAt(i)];
            if (b < 0) continue;
            v = (v << 5) + (long)(b & 0xFF);
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        while (value != 0L) {
            int v = (int)(value & 0x1FL);
            value >>>= 5;
            text.append(Base32IntConverter.DECODE[v]);
        }
        StringUtils.reverse((StringBuilder)text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }
}

