/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import net.openhft.chronicle.values.Align;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.Generators;
import net.openhft.chronicle.values.Group;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;

public abstract class FieldModel {
    String name;
    Class<?> type;
    long groupOrder = 0L;
    boolean alignmentSpecifiedExplicitly;
    int offsetAlignment;
    int dontCrossAlignment;
    Method get;
    Method getVolatile;
    Method getUsing;
    Method set;
    Method setVolatile;
    Method setOrdered;
    Method add;
    Method addAtomic;
    Method compareAndSwap;
    private MemberGenerator heapGenerator;

    static void genVerifiedElementOffset(ArrayFieldModel arrayField, MethodSpec.Builder methodBuilder) {
        int elemBitExtent = arrayField.elemBitExtent();
        assert (elemBitExtent % 8 == 0);
        int elemByteExtent = elemBitExtent / 8;
        methodBuilder.addStatement("long elementOffset = index * $LL", new Object[]{elemByteExtent});
    }

    void addLayoutInfo(Method m, MethodTemplate template) {
        Align align;
        Group group = m.getAnnotation(Group.class);
        if (group != null) {
            long offset = 0x100000000L;
            this.groupOrder = offset + (long)group.value();
        }
        if ((align = m.getAnnotation(Align.class)) != null) {
            if (align.offset() > 0 && align.dontCross() >= 0 && align.dontCross() % align.offset() != 0) {
                throw new IllegalStateException(align + " dontCross alignment should be a multiple of offset alignment, field " + this.name);
            }
            this.setOffsetAlignmentExplicitly(align.offset());
            this.dontCrossAlignment = align.dontCross();
        }
    }

    void setOffsetAlignmentExplicitly(int offsetAlignment) {
        if (this.alignmentSpecifiedExplicitly) {
            throw new IllegalStateException("Alignment for the field " + this.name + " should be specified only once");
        }
        this.alignmentSpecifiedExplicitly = true;
        this.offsetAlignment = offsetAlignment;
    }

    void resetAlignment() {
        this.alignmentSpecifiedExplicitly = false;
    }

    void addTypeInfo(Method m, MethodTemplate template) {
        Class<?> fieldType = template.fieldType.apply(m);
        if (this.type != null && this.type != fieldType) {
            throw new IllegalStateException("different field types in methods of the field " + this.name + ": " + this.type + " " + fieldType);
        }
        this.type = fieldType;
    }

    final void addInfo(Method m, MethodTemplate template) {
        this.addTypeInfo(m, template);
        this.addLayoutInfo(m, template);
    }

    abstract int sizeInBits();

    final int sizeInBytes() {
        int sizeInBits = this.sizeInBits();
        assert (sizeInBits % 8 == 0);
        return sizeInBits / 8;
    }

    abstract int offsetAlignmentInBytes();

    int dontCrossAlignmentInBytes() {
        if (this.dontCrossAlignment == -1) {
            return 0;
        }
        return this.dontCrossAlignment;
    }

    final int maxAlignmentInBytes() {
        return Math.max(this.offsetAlignmentInBytes(), this.dontCrossAlignmentInBytes());
    }

    final int offsetAlignmentInBits() {
        int offset = this.offsetAlignmentInBytes();
        return offset > 0 ? offset * 8 : 1;
    }

    final int dontCrossAlignmentInBits() {
        return this.dontCrossAlignmentInBytes() * 8;
    }

    void postProcess() {
    }

    void checkState() {
        this.checkDontCrossMultipleOfOffsetAlignment();
        this.checkDontCrossSmallerThanSize();
    }

    void checkAnyWriteMethodPresent() {
        if (this.set == null && this.setVolatile == null && this.setOrdered == null && this.add == null && this.addAtomic == null && this.compareAndSwap == null) {
            throw new IllegalStateException("Some writing method should be present for field " + this.name);
        }
    }

    void checkDontCrossMultipleOfOffsetAlignment() {
        int offset = this.offsetAlignmentInBytes();
        int dontCross = this.dontCrossAlignmentInBytes();
        if (offset != 0 && dontCross % offset != 0) {
            throw new IllegalStateException("offset alignment " + offset + "should be a multiple of dontCross alignment " + dontCross + ", field " + this.name);
        }
    }

    void checkDontCrossSmallerThanSize() {
        int dontCross = this.dontCrossAlignmentInBits();
        if (dontCross != 0 && dontCross < this.sizeInBits()) {
            throw new IllegalStateException("dontCross alignment should be wider than the field " + this.name + " itself");
        }
    }

    MemberGenerator nativeGenerator() {
        throw new UnsupportedOperationException(this.getClass() + "");
    }

    MemberGenerator createHeapGenerator() {
        throw new UnsupportedOperationException(this.getClass() + "");
    }

    MemberGenerator heapGenerator() {
        if (this.heapGenerator == null) {
            this.heapGenerator = this.createHeapGenerator();
        }
        return this.heapGenerator;
    }

    void generateNativeMembers(ValueBuilder valueBuilder) {
        this.generateMembers(this.nativeGenerator(), valueBuilder);
    }

    void generateHeapMembers(ValueBuilder valueBuilder) {
        this.generateMembers(this.heapGenerator(), valueBuilder);
    }

    void generateMembers(MemberGenerator generator, ValueBuilder valueBuilder) {
        generator.generateFields(valueBuilder);
        this.generateMethod(valueBuilder, this.get, generator::generateGet, new String[0]);
        this.generateMethod(valueBuilder, this.getVolatile, generator::generateGetVolatile, new String[0]);
        this.generateMethod(valueBuilder, this.getUsing, generator::generateGetUsing, this.usingName());
        this.generateMethod(valueBuilder, this.set, generator::generateSet, this.varName());
        this.generateMethod(valueBuilder, this.setVolatile, generator::generateSetVolatile, this.varName());
        this.generateMethod(valueBuilder, this.setOrdered, generator::generateSetOrdered, this.varName());
        this.generateMethod(valueBuilder, this.add, generator::generateAdd, "addition");
        this.generateMethod(valueBuilder, this.addAtomic, generator::generateAddAtomic, "addition");
        this.generateMethod(valueBuilder, this.compareAndSwap, generator::generateCompareAndSwap, this.oldName(), this.newName());
    }

    public String name() {
        return this.name;
    }

    String varName() {
        return "_" + this.name;
    }

    public String fieldName() {
        return "__field" + this.name;
    }

    String usingName() {
        return "using" + Utils.capitalize(this.name);
    }

    String oldName() {
        return "old" + Utils.capitalize(this.name);
    }

    String newName() {
        return "new" + Utils.capitalize(this.name);
    }

    String capTypeName() {
        return Utils.capitalize(this.type.getName());
    }

    String readMethod() {
        if (this.type == Character.TYPE) {
            return "readUnsignedShort";
        }
        return "read" + this.capTypeName();
    }

    String writeMethod() {
        if (this.type == Character.TYPE) {
            return "writeUnsignedShort";
        }
        return "write" + this.capTypeName();
    }

    private void generateMethod(ValueBuilder valueBuilder, Method m, BiConsumer<ValueBuilder, MethodSpec.Builder> generate, String ... parameterNames) {
        if (m != null) {
            ArrayList<String> paramNames = new ArrayList<String>();
            if (this instanceof ArrayFieldModel) {
                paramNames.add("index");
            }
            paramNames.addAll(Arrays.asList(parameterNames));
            MethodSpec.Builder methodBuilder = Generators.methodBuilder(m, paramNames);
            generate.accept(valueBuilder, methodBuilder);
            valueBuilder.typeBuilder.addMethod(methodBuilder.build());
        }
    }

    void setGet(Method get) {
        if (this.get != null) {
            throw new IllegalStateException("Get method is already declared for the field " + this.name + ": " + this.get.getName() + ", " + get.getName());
        }
        this.get = get;
    }

    public Method get() {
        return this.get;
    }

    void setGetVolatile(Method getVolatile) {
        if (this.getVolatile != null) {
            throw new IllegalStateException("GetVolatile is already declared for the field" + this.name + ": " + this.getVolatile.getName() + ", " + getVolatile.getName());
        }
        this.getVolatile = getVolatile;
    }

    void setGetUsing(Method getUsing) {
        if (this.getUsing != null) {
            throw new IllegalStateException("GetUsing is already declared for the field " + this.name + ": " + this.getUsing.getName() + ", " + getUsing.getName());
        }
        this.getUsing = getUsing;
    }

    void setSet(Method set) {
        if (this.set != null) {
            throw new IllegalStateException("Set method is already declared for the field " + this.name + ": " + this.set.getName() + ", " + set.getName());
        }
        this.set = set;
    }

    public Method set() {
        return this.set;
    }

    public Method setOrSetOrderedOrSetVolatile() {
        if (this.set != null) {
            return this.set;
        }
        if (this.setOrdered != null) {
            return this.setOrdered;
        }
        if (this.setVolatile != null) {
            return this.setVolatile;
        }
        throw new IllegalStateException("set or setVolatile or setOrdered expected for field " + this.name);
    }

    void setSetVolatile(Method setVolatile) {
        if (this.setVolatile != null) {
            throw new IllegalStateException("SetVolatile is already declared for the field " + this.name + ": " + this.setVolatile.getName() + ", " + setVolatile.getName());
        }
        this.setVolatile = setVolatile;
    }

    void setSetOrdered(Method setOrdered) {
        if (this.setOrdered != null) {
            throw new IllegalStateException("SetOrdered is already declared for the field " + this.name + ": " + this.setOrdered.getName() + ", " + setOrdered.getName());
        }
        this.setOrdered = setOrdered;
    }

    void setAdd(Method add) {
        if (this.add != null) {
            throw new IllegalStateException("Add method is already declared for the field " + this.name + ": " + this.add.getName() + ", " + add.getName());
        }
        this.add = add;
    }

    void setAddAtomic(Method addAtomic) {
        if (this.addAtomic != null) {
            throw new IllegalStateException("AddAtomic is already declared for the field " + this.name + ": " + this.addAtomic.getName() + ", " + addAtomic.getName());
        }
        this.addAtomic = addAtomic;
    }

    void setCompareAndSwap(Method compareAndSwap) {
        if (this.compareAndSwap != null) {
            throw new IllegalStateException("CompareAndSwap is already declared for the field " + this.name + ": " + this.compareAndSwap.getName() + ", " + compareAndSwap.getName());
        }
        this.compareAndSwap = compareAndSwap;
    }

    int verifiedByteOffset(ValueBuilder valueBuilder) {
        int bitOffset = valueBuilder.model.fieldBitOffset(this);
        assert (bitOffset % 8 == 0) : this.getClass().getSimpleName() + " " + this.name + " should be byte-aligned";
        return bitOffset / 8;
    }

    void checkArgumentNotNull(MethodSpec.Builder builder) {
        builder.beginControlFlow("if ($N == null)", new Object[]{this.varName()});
        builder.addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, this.name + " shouldn't be null"});
        builder.endControlFlow();
    }

    public Method getOrGetVolatile() {
        if (this.get != null) {
            return this.get;
        }
        if (this.getVolatile != null) {
            return this.getVolatile;
        }
        throw new IllegalStateException("get or getVolatile expected for field " + this.name);
    }
}

