/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.values.CachedCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum CompilerUtils {

    public static final CachedCompiler CACHED_COMPILER = new CachedCompiler();
    private static final Method DEFINE_CLASS_METHOD;
    static JavaCompiler s_compiler;
    static StandardJavaFileManager s_standardJavaFileManager;

    private static void reset() {
        s_compiler = ToolProvider.getSystemJavaCompiler();
        if (s_compiler == null) {
            try {
                Class<?> javacTool = Class.forName("com.sun.tools.javac.api.JavacTool");
                Method create = javacTool.getMethod("create", new Class[0]);
                s_compiler = (JavaCompiler)create.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        s_standardJavaFileManager = s_compiler.getStandardFileManager(null, null, null);
    }

    public static Class defineClass(@Nullable ClassLoader classLoader, @NotNull String className, @NotNull byte[] bytes) {
        try {
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)classLoader, className, bytes, 0, bytes.length);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }

    static {
        try {
            DEFINE_CLASS_METHOD = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            Jvm.setAccessible((AccessibleObject)DEFINE_CLASS_METHOD);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        CompilerUtils.reset();
    }
}

