/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Map;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

final class BytecodeGen {
    static final ClassLoader VALUES_CLASS_LOADER = BytecodeGen.canonicalize(BytecodeGen.class.getClassLoader());
    static final String VALUES_PACKAGE = BytecodeGen.class.getName().replaceFirst("\\.values\\..*$", ".values");
    static final String BYTES_PACKAGE = Bytes.class.getName().replaceFirst("\\.bytes\\..*$", ".bytes");
    private static final CustomClassLoadingOption CUSTOM_CLASS_LOADING = BytecodeGen.parseCustomClassLoadingOption();
    private static final Map<ClassLoader, WeakReference<ClassLoader>> CLASS_LOADER_CACHE = new WeakIdentityHashMap();

    BytecodeGen() {
    }

    public static CustomClassLoadingOption getCustomClassLoadingOption() {
        return CUSTOM_CLASS_LOADING;
    }

    private static CustomClassLoadingOption parseCustomClassLoadingOption() {
        return BytecodeGen.getSystemOption("chronicle_values_custom_class_loading", CustomClassLoadingOption.BRIDGE, CustomClassLoadingOption.OFF);
    }

    private static <T extends Enum<T>> T getSystemOption(String name, T defaultValue, T secureValue) {
        Class<T> enumType = defaultValue.getDeclaringClass();
        String value = null;
        try {
            value = AccessController.doPrivileged(() -> Jvm.getProperty((String)name));
            return value != null && value.length() > 0 ? Enum.valueOf(enumType, value) : defaultValue;
        }
        catch (SecurityException e) {
            return secureValue;
        }
        catch (IllegalArgumentException e) {
            Jvm.warn().on(BytecodeGen.class, value + " is not a valid flag value for " + name + ".  Values must be one of " + Arrays.asList(enumType.getEnumConstants()));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader getFromClassLoaderCache(ClassLoader typeClassLoader) {
        Map<ClassLoader, WeakReference<ClassLoader>> map = CLASS_LOADER_CACHE;
        synchronized (map) {
            return (ClassLoader)CLASS_LOADER_CACHE.compute(typeClassLoader, (k, ref) -> {
                if (ref == null || ref.get() == null) {
                    Jvm.debug().on(BytecodeGen.class, "Creating a bridge ClassLoader for " + typeClassLoader);
                    return AccessController.doPrivileged(() -> new WeakReference<BridgeClassLoader>(new BridgeClassLoader(typeClassLoader)));
                }
                return ref;
            }).get();
        }
    }

    private static ClassLoader canonicalize(ClassLoader classLoader) {
        return classLoader != null ? classLoader : SystemBridgeHolder.SYSTEM_BRIDGE.getParent();
    }

    public static ClassLoader getClassLoader(Class<?> type) {
        return BytecodeGen.getClassLoader(type, type.getClassLoader());
    }

    private static ClassLoader getClassLoader(Class<?> type, ClassLoader delegate) {
        if (BytecodeGen.getCustomClassLoadingOption() == CustomClassLoadingOption.OFF) {
            return delegate;
        }
        if (type.getName().startsWith("java.")) {
            return VALUES_CLASS_LOADER;
        }
        if ((delegate = BytecodeGen.canonicalize(delegate)) == VALUES_CLASS_LOADER || delegate instanceof BridgeClassLoader) {
            return delegate;
        }
        if (Visibility.forType(type) == Visibility.PUBLIC) {
            if (delegate != SystemBridgeHolder.SYSTEM_BRIDGE.getParent()) {
                return BytecodeGen.getFromClassLoaderCache(delegate);
            }
            return SystemBridgeHolder.SYSTEM_BRIDGE;
        }
        return delegate;
    }

    static class BridgeClassLoader
    extends ClassLoader {
        BridgeClassLoader() {
        }

        BridgeClassLoader(ClassLoader usersClassLoader) {
            super(usersClassLoader);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("sun.reflect")) {
                return SystemBridgeHolder.SYSTEM_BRIDGE.classicLoadClass(name, resolve);
            }
            if (name.startsWith(VALUES_PACKAGE) || name.startsWith(BYTES_PACKAGE)) {
                if (null == VALUES_CLASS_LOADER) {
                    return SystemBridgeHolder.SYSTEM_BRIDGE.classicLoadClass(name, resolve);
                }
                try {
                    Class<?> clazz = VALUES_CLASS_LOADER.loadClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.classicLoadClass(name, resolve);
        }

        Class<?> classicLoadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }

    private static class SystemBridgeHolder {
        static final BridgeClassLoader SYSTEM_BRIDGE = new BridgeClassLoader();

        private SystemBridgeHolder() {
        }
    }

    public static enum Visibility {
        PUBLIC{

            @Override
            public Visibility and(Visibility that) {
                return that;
            }
        }
        ,
        SAME_PACKAGE{

            @Override
            public Visibility and(Visibility that) {
                return this;
            }
        };


        public static Visibility forType(Class<?> type) {
            return (type.getModifiers() & 5) != 0 ? PUBLIC : SAME_PACKAGE;
        }

        public abstract Visibility and(Visibility var1);
    }

    public static enum CustomClassLoadingOption {
        OFF,
        BRIDGE;

    }
}

