/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.Enums;
import net.openhft.chronicle.values.FieldNullability;
import net.openhft.chronicle.values.IntegerBackedFieldModel;
import net.openhft.chronicle.values.IntegerBackedNativeMemberGenerator;
import net.openhft.chronicle.values.IntegerFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Nullability;
import net.openhft.chronicle.values.ObjectHeapMemberGenerator;
import net.openhft.chronicle.values.RangeImpl;
import net.openhft.chronicle.values.ValueBuilder;

class EnumFieldModel
extends IntegerBackedFieldModel {
    final FieldNullability nullability = new FieldNullability(this);
    final MemberGenerator nativeGenerator = new IntegerBackedNativeMemberGenerator(this, this.backend){

        @Override
        public void generateFields(ValueBuilder valueBuilder) {
            EnumFieldModel.this.addUniverseField(valueBuilder);
        }

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            EnumFieldModel.this.addUniverseField(valueBuilder);
        }

        @Override
        void finishGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String value) {
            methodBuilder.addStatement("return $N", new Object[]{EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, value)});
        }

        @Override
        String startSet(MethodSpec.Builder methodBuilder) {
            return EnumFieldModel.this.toOrdinalOrMinusOne(EnumFieldModel.this.varName());
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String value = EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE));
            methodBuilder.addCode("if (($N) != other.$N()) return false;\n", new Object[]{value, EnumFieldModel.this.getOrGetVolatile().getName()});
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String value = EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE));
            methodBuilder.addCode("if (($N) != other.$N(index)) return false;\n", new Object[]{value, arrayFieldModel.getOrGetVolatile().getName()});
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String value = EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE));
            return String.format("java.util.Objects.hashCode(%s)", value);
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String value = EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE));
            return String.format("java.util.Objects.hashCode(%s)", value);
        }
    };

    EnumFieldModel() {
    }

    @Override
    void addTypeInfo(Method m, MethodTemplate template) {
        super.addTypeInfo(m, template);
        this.nullability.addInfo(m, template);
    }

    @Override
    void postProcess() {
        super.postProcess();
        int min = this.nullable() ? -1 : 0;
        int constants = Enums.numberOfConstants(this.type);
        if (constants == 0) {
            throw new IllegalStateException(this.name + "field type is a enum with zero constants: " + this.type);
        }
        this.backend.type = Integer.TYPE;
        this.backend.range = new RangeImpl(min, constants - 1);
        this.backend.postProcess();
    }

    private boolean nullable() {
        return this.nullability.nullability() == Nullability.NULLABLE;
    }

    private String universeName() {
        return this.name + "Universe";
    }

    private void addUniverseField(ValueBuilder valueBuilder) {
        FieldSpec universe = FieldSpec.builder((TypeName)ArrayTypeName.of((Type)this.type), (String)this.universeName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.getUniverse($T.class)", new Object[]{Enums.class, this.type}).build();
        valueBuilder.typeBuilder.addField(universe);
    }

    private String toOrdinalOrMinusOne(String e) {
        if (this.nullable()) {
            return String.format("(%s != null ? %s.ordinal() : -1)", e, e);
        }
        return e + ".ordinal()";
    }

    private String fromOrdinalOrMinusOne(MethodSpec.Builder methodBuilder, String value) {
        if (this.nullable()) {
            String ordinalVariableName = this.name() + "Ordinal";
            methodBuilder.addStatement(String.format("int %s = %s", ordinalVariableName, value), new Object[0]);
            return String.format("%s >= 0 ? %s[%s] : null", ordinalVariableName, this.universeName(), ordinalVariableName);
        }
        return String.format("%s[%s]", this.universeName(), value);
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new ObjectHeapMemberGenerator(this){

            @Override
            public void generateFields(ValueBuilder valueBuilder) {
                super.generateFields(valueBuilder);
                EnumFieldModel.this.addUniverseField(valueBuilder);
            }

            @Override
            void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
                super.generateArrayElementFields(arrayFieldModel, valueBuilder);
                EnumFieldModel.this.addUniverseField(valueBuilder);
            }

            @Override
            void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("bytes.writeStopBit($N)", new Object[]{EnumFieldModel.this.toOrdinalOrMinusOne(EnumFieldModel.this.fieldName())});
            }

            @Override
            void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("bytes.writeStopBit($N))", new Object[]{EnumFieldModel.this.toOrdinalOrMinusOne(EnumFieldModel.this.fieldName() + "[index]")});
            }

            @Override
            void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N = $N", new Object[]{EnumFieldModel.this.fieldName(), EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, "(int) bytes.readStopBit()")});
            }

            @Override
            void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index] = $N", new Object[]{EnumFieldModel.this.fieldName(), EnumFieldModel.this.fromOrdinalOrMinusOne(methodBuilder, "(int) bytes.readStopBit()")});
            }
        };
    }
}

