/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.PrimitiveBackedHeapMemberGenerator;
import net.openhft.chronicle.values.PrimitiveFieldModel;
import net.openhft.chronicle.values.ValueBuilder;

class BooleanFieldModel
extends PrimitiveFieldModel {
    private MemberGenerator nativeGenerator = new MemberGenerator(this){

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
        }

        @Override
        void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.get(valueBuilder, methodBuilder, "");
        }

        private void get(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String readType) {
            int bitOffset = valueBuilder.model.fieldBitOffset(BooleanFieldModel.this);
            int byteOffset = bitOffset / 8;
            int bitShift = bitOffset & 7;
            methodBuilder.addStatement("return (bs.read$NByte(offset + $L) & (1 << $L)) != 0", new Object[]{readType, byteOffset, bitShift});
        }

        @Override
        void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.arrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, "");
        }

        private void arrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String readType) {
            arrayFieldModel.checkBounds(methodBuilder);
            int arrayBitOffset = valueBuilder.model.fieldBitOffset(arrayFieldModel);
            methodBuilder.addStatement("int bitOffset = $L + index", new Object[]{arrayBitOffset});
            methodBuilder.addStatement("int byteOffset = bitOffset / 8", new Object[0]);
            methodBuilder.addStatement("int bitShift = bitOffset & 7", new Object[0]);
            methodBuilder.addStatement("return (bs.read$NByte(offset + byteOffset) & (1 << bitShift)) != 0", new Object[]{readType});
        }

        @Override
        void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.get(valueBuilder, methodBuilder, "Volatile");
        }

        @Override
        void generateArrayElementGetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.arrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, "Volatile");
        }

        @Override
        void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.set(valueBuilder, methodBuilder, "", "");
        }

        private void set(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String readType, String writeType) {
            int bitOffset = valueBuilder.model.fieldBitOffset(BooleanFieldModel.this);
            int byteOffset = bitOffset / 8;
            int bitShift = bitOffset & 7;
            methodBuilder.addStatement("int b = bs.read$NByte(offset + $L)", new Object[]{readType, byteOffset});
            methodBuilder.beginControlFlow("if ($N)", new Object[]{BooleanFieldModel.this.varName()});
            methodBuilder.addStatement("b |= (1 << $L)", new Object[]{bitShift});
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("b &= ~(1 << $L)", new Object[]{bitShift});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("bs.write$NByte(offset + $L, (byte) b)", new Object[]{writeType, byteOffset});
        }

        @Override
        void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.arrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, "", "");
        }

        private void arrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String readType, String writeType) {
            int arrayBitOffset = valueBuilder.model.fieldBitOffset(arrayFieldModel);
            methodBuilder.addStatement("int bitOffset = $L + index", new Object[]{arrayBitOffset});
            methodBuilder.addStatement("int byteOffset = bitOffset / 8", new Object[0]);
            methodBuilder.addStatement("int bitShift = bitOffset & 7", new Object[0]);
            methodBuilder.addStatement("int b = bs.read$NByte(offset + byteOffset)", new Object[]{readType});
            methodBuilder.beginControlFlow("if ($N)", new Object[]{BooleanFieldModel.this.varName()});
            methodBuilder.addStatement("b |= (1 << bitShift)", new Object[0]);
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("b &= ~(1 << bitShift)", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("bs.write$NByte(offset + byteOffset, (byte) b)", new Object[]{writeType});
        }

        @Override
        void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.set(valueBuilder, methodBuilder, "Volatile", "Volatile");
        }

        @Override
        void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.arrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, "Volatile", "Volatile");
        }

        @Override
        void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int bitOffset = valueBuilder.model.fieldBitOffset(BooleanFieldModel.this);
            int byteOffset = bitOffset / 8;
            methodBuilder.addStatement("long byteOffset = (offset + $L) & ~3L", new Object[]{byteOffset});
            methodBuilder.addStatement("int bitShift = (int) (((offset * 8) + $L) & 31)", new Object[]{bitOffset});
            this.endSetOrdered(methodBuilder);
        }

        private void endSetOrdered(MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("int i = bs.readVolatileInt(byteOffset)", new Object[0]);
            methodBuilder.beginControlFlow("if ($N)", new Object[]{BooleanFieldModel.this.varName()});
            methodBuilder.addStatement("i |= (1 << bitShift)", new Object[0]);
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("i &= ~(1 << bitShift)", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("bs.writeOrderedInt(byteOffset, i)", new Object[0]);
        }

        @Override
        void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            int arrayBitOffset = valueBuilder.model.fieldBitOffset(arrayFieldModel);
            methodBuilder.addStatement("long bitOffset = (offset * 8) + $L + index", new Object[]{arrayBitOffset});
            methodBuilder.addStatement("long byteOffset = (bitOffset / 32) * 4", new Object[0]);
            methodBuilder.addStatement("int bitShift = (int) ((bitOffset + $L) & 31)", new Object[0]);
            this.endSetOrdered(methodBuilder);
        }

        @Override
        void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int bitOffset = valueBuilder.model.fieldBitOffset(BooleanFieldModel.this);
            int byteOffset = bitOffset / 8;
            methodBuilder.addStatement("long byteOffset = (offset + $L) & ~3L", new Object[]{byteOffset});
            methodBuilder.addStatement("int bitShift = (int) (((offset * 8) + $L) & 31)", new Object[]{bitOffset});
            this.endCompareAndSwap(methodBuilder);
        }

        private void endCompareAndSwap(MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("int i = bs.readVolatileInt(byteOffset), x", new Object[0]);
            methodBuilder.beginControlFlow("if ($N)", new Object[]{BooleanFieldModel.this.newName()});
            methodBuilder.addStatement("x = i | (1 << bitShift)", new Object[0]);
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("x = i & ~(1 << bitShift)", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.beginControlFlow("if ($N == $N)", new Object[]{BooleanFieldModel.this.oldName(), BooleanFieldModel.this.newName()});
            methodBuilder.addCode("if (i != x) return false;\n", new Object[0]);
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addCode("if (i == x) return false;\n", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return bs.compareAndSwapInt(byteOffset, i, x)", new Object[0]);
        }

        @Override
        void generateArrayElementCompareAndSwap(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            int arrayBitOffset = valueBuilder.model.fieldBitOffset(arrayFieldModel);
            methodBuilder.addStatement("long bitOffset = (offset * 8) + $L + index", new Object[]{arrayBitOffset});
            methodBuilder.addStatement("long byteOffset = (bitOffset / 32) * 4", new Object[0]);
            methodBuilder.addStatement("int bitShift = (int) ((bitOffset + $L) & 31)", new Object[0]);
            this.endCompareAndSwap(methodBuilder);
        }

        @Override
        void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String from = String.format("from.%s()", BooleanFieldModel.this.getOrGetVolatile().getName());
            this.copyFrom(valueBuilder, methodBuilder, from);
        }

        private void copyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String from) {
            if (BooleanFieldModel.this.set != null) {
                methodBuilder.addStatement("$N($N)", new Object[]{BooleanFieldModel.this.set.getName(), from});
            } else {
                methodBuilder.addStatement("boolean $N = $N", new Object[]{BooleanFieldModel.this.varName(), from});
                this.set(valueBuilder, methodBuilder, "", "");
            }
        }

        @Override
        void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String from = String.format("from.%s(index)", arrayFieldModel.getOrGetVolatile().getName());
            this.arrayElementCopyFrom(arrayFieldModel, valueBuilder, methodBuilder, from);
        }

        private void arrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String from) {
            if (arrayFieldModel.set != null) {
                methodBuilder.addStatement("$N(index, $N)", new Object[]{arrayFieldModel.set.getName(), from});
            } else {
                methodBuilder.addStatement("boolean $N = $N", new Object[]{BooleanFieldModel.this.varName(), from});
                this.arrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, "", "");
            }
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.copyFrom(valueBuilder, methodBuilder, "bytes.readBoolean()");
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.arrayElementCopyFrom(arrayFieldModel, valueBuilder, methodBuilder, "bytes.readBoolean()");
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addCode("if ($N() != other.$N()) return false;\n", new Object[]{BooleanFieldModel.this.getOrGetVolatile().getName(), BooleanFieldModel.this.getOrGetVolatile().getName()});
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String get = arrayFieldModel.getOrGetVolatile().getName();
            methodBuilder.addCode("if ($N(index) != other.$N(index)) return false;\n", new Object[]{get, get});
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return String.format("Boolean.hashCode(%s())", BooleanFieldModel.this.getOrGetVolatile().getName());
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return String.format("Boolean.hashCode(%s(index))", arrayFieldModel.getOrGetVolatile().getName());
        }
    };

    BooleanFieldModel() {
    }

    @Override
    int offsetAlignmentInBytes() {
        if (this.offsetAlignment == -1) {
            throw new IllegalStateException("Default offset alignment doesn't make sense for boolean field " + this.name);
        }
        return this.offsetAlignment;
    }

    @Override
    int dontCrossAlignmentInBytes() {
        if (this.dontCrossAlignment == -1) {
            throw new IllegalStateException("Default dontCross alignment doesn't make sense for boolean field " + this.name);
        }
        return this.dontCrossAlignment;
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new PrimitiveBackedHeapMemberGenerator(this){};
    }
}

