/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;

public abstract class TimedEventHandler
implements EventHandler {
    private long nextRunNS = 0L;

    public boolean action() throws InvalidEventHandlerException {
        long now = System.nanoTime();
        if (this.nextRunNS <= now) {
            long delayUS = this.timedAction();
            if (delayUS < 0L) {
                return true;
            }
            this.nextRunNS = now + delayUS * 1000L;
        }
        return false;
    }

    protected abstract long timedAction() throws InvalidEventHandlerException;

    @NotNull
    public HandlerPriority priority() {
        HandlerPriority handlerPriority = HandlerPriority.TIMER;
        if (handlerPriority == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/threads/TimedEventHandler.priority must not return null");
        }
        if (handlerPriority == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/threads/TimedEventHandler.priority must not return null");
        }
        return handlerPriority;
    }
}

