/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads.internal;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.openhft.affinity.Affinity;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.ThreadHolder;

public class ThreadsThreadHolder
implements ThreadHolder {
    private final String description;
    private final long timeLimit;
    private final LongSupplier timeSupplier;
    private final Supplier<Thread> threadSupplier;
    private final BooleanSupplier logEnabled;
    private final Consumer<String> logConsumer;
    private long lastTime = 0L;

    public ThreadsThreadHolder(String description, long timeLimit, LongSupplier timeSupplier, Supplier<Thread> threadSupplier, BooleanSupplier logEnabled, Consumer<String> logConsumer) {
        this.description = description;
        this.timeLimit = timeLimit;
        this.timeSupplier = timeSupplier;
        this.threadSupplier = threadSupplier;
        this.logEnabled = logEnabled;
        this.logConsumer = logConsumer;
    }

    @Override
    public boolean isAlive() throws InvalidEventHandlerException {
        return this.threadSupplier.get().isAlive();
    }

    @Override
    public void resetTimers() {
    }

    @Override
    public void reportFinished() {
    }

    @Override
    public long startedNS() {
        return this.timeSupplier.getAsLong();
    }

    @Override
    public void monitorThreadDelayed(long actionCallDelayNS) {
        this.logConsumer.accept("Monitor thread for " + this.getName() + " cpuId: " + Affinity.getCpu() + " was delayed by " + (double)(actionCallDelayNS / 100000L) / 10.0 + " ms");
    }

    @Override
    public boolean shouldLog(long nowNS) {
        return nowNS - this.startedNS() > this.timeLimit && this.logEnabled.getAsBoolean();
    }

    @Override
    public void dumpThread(long startedNS, long nowNS) {
        long latency = nowNS - startedNS;
        Thread thread = this.threadSupplier.get();
        String type = startedNS == this.lastTime ? "re-reporting" : "new report";
        StringBuilder out = new StringBuilder().append("THIS IS NOT AN ERROR, but a profile of the thread, ").append(this.description).append(" thread ").append(thread.getName()).append(" interrupted ").append(thread.isInterrupted()).append(" blocked for ").append((double)latency / 100000.0 / 10.0).append(" ms. ").append(type);
        Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])thread.getStackTrace());
        this.logConsumer.accept(out.toString());
        this.lastTime = startedNS;
    }

    @Override
    public long timingTolerance() {
        return this.timeLimit + this.timingError();
    }

    protected long timingError() {
        return TIMING_ERROR;
    }

    @Override
    public String getName() {
        return this.threadSupplier.get().getName();
    }
}

