/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorEventLoop
implements EventLoop,
Runnable,
Closeable {
    static final Logger LOG = LoggerFactory.getLogger(MonitorEventLoop.class);
    final ExecutorService service = Executors.newSingleThreadExecutor(new NamedThreadFactory("event-loop-monitor", true));
    private final EventLoop parent;
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final Pauser pauser;
    private volatile boolean running = true;

    public MonitorEventLoop(EventLoop parent, Pauser pauser) {
        this.parent = parent;
        this.pauser = pauser;
    }

    public void start() {
        this.running = true;
        this.service.submit(this);
    }

    public void unpause() {
        this.pauser.unpause();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isClosed() {
        return !this.service.isShutdown();
    }

    public boolean isAlive() {
        return this.running;
    }

    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        this.addHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(@NotNull EventHandler handler) {
        List<EventHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
            handler.eventLoop(this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            for (int i = 0; i < 200; ++i) {
                if (!this.running) continue;
                Jvm.pause((long)50L);
            }
            while (this.running) {
                boolean busy;
                List<EventHandler> list = this.handlers;
                synchronized (list) {
                    busy = this.runHandlers();
                }
                this.pauser.pause();
                if (!busy) continue;
                this.pauser.reset();
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @HotMethod
    private boolean runHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            EventHandler handler = this.handlers.get(i);
            if (handler == null) continue;
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.handlers.remove(i--);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), (Throwable)e);
            }
        }
        return busy;
    }

    @Override
    public void close() {
        this.stop();
        Threads.shutdown(this.service);
    }
}

