/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.openhft.chronicle.releasenotes.model.Issue;

public class SimpleIssue
implements Issue {
    private final int number;
    private final String title;
    private final URL url;
    private final List<String> labels;
    private final Optional<String> comment;

    public SimpleIssue(int number, String title, List<String> labels, Optional<String> comment, URL url) {
        this.number = number;
        this.title = Objects.requireNonNull(title);
        this.labels = Collections.unmodifiableList(Objects.requireNonNull(labels));
        this.comment = Objects.requireNonNull(comment);
        this.url = Objects.requireNonNull(url);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleIssue issue = (SimpleIssue)o;
        return this.number == issue.number && this.title.equals(issue.title) && this.labels.equals(issue.labels) && this.comment.equals(issue.comment) && this.url.equals(issue.url);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.title, this.labels, this.comment, this.url);
    }

    public String toString() {
        return "FullIssue{number=" + this.number + ", title='" + this.title + '\'' + ", labels=" + this.labels + ", comment=" + this.comment + ", url=" + this.url.toString() + '}';
    }
}

