/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.util.Objects;

public final class ReleaseNote {
    private final String tag;
    private final String title;
    private final String body;

    public ReleaseNote(String tag, String title, String body) {
        this.tag = Objects.requireNonNull(tag);
        this.title = Objects.requireNonNull(title);
        this.body = Objects.requireNonNull(body);
    }

    public String getTag() {
        return this.tag;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseNote releaseNote = (ReleaseNote)o;
        return this.tag.equals(releaseNote.tag) && this.title.equals(releaseNote.title) && this.body.equals(releaseNote.body);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.title, this.body);
    }

    public String toString() {
        return "Release{tag='" + this.tag + '\'' + ", title='" + this.title + '\'' + ", body='" + this.body + '\'' + '}';
    }
}

