/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.model.Label;

public final class Issue {
    private final int number;
    private final String title;
    private final List<Label> labels;
    private final URL url;

    public Issue(int number, String title, List<Label> labels) {
        this(number, title, labels, null);
    }

    public Issue(int number, String title, List<Label> labels, URL url) {
        this.number = number;
        this.title = Objects.requireNonNull(title);
        this.labels = Objects.requireNonNull(labels);
        this.url = url;
    }

    public int getNumber() {
        return this.number;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Label> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return this.number == issue.number && this.title.equals(issue.title) && this.labels.equals(issue.labels);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.title, this.labels);
    }

    public String toString() {
        return "Issue{number=" + this.number + ", title='" + this.title + '\'' + ", labels=" + this.labels + '}';
    }
}

