/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.connector.Connector;
import net.openhft.chronicle.releasenotes.connector.ReleaseException;
import net.openhft.chronicle.releasenotes.model.ReleaseNote;

public interface ReleaseConnector
extends Connector,
AutoCloseable {
    public ReleaseResult createReleaseFromBranch(String var1, String var2, String var3, BranchReleaseOptions var4);

    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String branch) {
        return this.createReleaseFromBranch(repository, tag, branch, BranchReleaseOptions.DEFAULT);
    }

    public ReleaseResult createReleaseFromBranch(String var1, String var2, String var3, String var4, BranchReleaseOptions var5);

    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String endTag, String branch) {
        return this.createReleaseFromBranch(repository, tag, endTag, branch, BranchReleaseOptions.DEFAULT);
    }

    public ReleaseResult createReleaseFromMilestone(String var1, String var2, String var3, MilestoneReleaseOptions var4);

    default public ReleaseResult createReleaseFromMilestone(String repository, String tag, String milestone) {
        return this.createReleaseFromMilestone(repository, tag, milestone, MilestoneReleaseOptions.DEFAULT);
    }

    public ReleaseResult createAggregatedRelease(String var1, String var2, Map<String, List<String>> var3, AggregateReleaseOptions var4);

    default public ReleaseResult createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases) {
        return this.createAggregatedRelease(repository, tag, releases, AggregateReleaseOptions.DEFAULT);
    }

    public ReleaseResult createAggregatedRelease(String var1, String var2, List<ReleaseNote> var3, AggregateReleaseOptions var4);

    default public ReleaseResult createAggregatedRelease(String repository, String tag, List<ReleaseNote> releaseNotes) {
        return this.createAggregatedRelease(repository, tag, releaseNotes, AggregateReleaseOptions.DEFAULT);
    }

    public ReleaseResult queryReleaseFromBranch(String var1, String var2, String var3, BranchReleaseOptions var4);

    default public ReleaseResult queryReleaseFromBranch(String repository, String tag, String branch) {
        return this.createReleaseFromBranch(repository, tag, branch, BranchReleaseOptions.DEFAULT);
    }

    @Override
    default public void close() throws Exception {
    }

    @Deprecated
    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String branch, List<String> ignoredLabels, boolean override) {
        BranchReleaseOptions releaseOptions = new BranchReleaseOptions.Builder().ignoreLabels(ignoredLabels).overrideRelease(override).build();
        return this.createReleaseFromBranch(repository, tag, branch, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String branch, List<String> ignoredLabels) {
        return this.createReleaseFromBranch(repository, tag, branch, ignoredLabels, false);
    }

    @Deprecated
    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String endTag, String branch, List<String> ignoredLabels, boolean override) {
        BranchReleaseOptions releaseOptions = new BranchReleaseOptions.Builder().ignoreLabels(ignoredLabels).overrideRelease(override).build();
        return this.createReleaseFromBranch(repository, tag, endTag, branch, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String endTag, String branch, List<String> ignoredLabels) {
        return this.createReleaseFromBranch(repository, tag, endTag, branch, ignoredLabels, false);
    }

    @Deprecated
    default public ReleaseResult createReleaseFromMilestone(String repository, String tag, String milestone, List<String> ignoredLabels, boolean override) {
        MilestoneReleaseOptions releaseOptions = new MilestoneReleaseOptions.Builder().ignoreLabels(ignoredLabels).overrideRelease(override).build();
        return this.createReleaseFromMilestone(repository, tag, milestone, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult createReleaseFromMilestone(String repository, String tag, String milestone, List<String> ignoredLabels) {
        return this.createReleaseFromMilestone(repository, tag, milestone, ignoredLabels, false);
    }

    @Deprecated
    default public ReleaseResult createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases, boolean override) {
        AggregateReleaseOptions releaseOptions = new AggregateReleaseOptions.Builder().overrideRelease(override).build();
        return this.createAggregatedRelease(repository, tag, releases, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult createAggregatedRelease(String repository, String tag, List<ReleaseNote> releaseNotes, boolean override) {
        AggregateReleaseOptions releaseOptions = new AggregateReleaseOptions.Builder().overrideRelease(override).build();
        return this.createAggregatedRelease(repository, tag, releaseNotes, releaseOptions);
    }

    public static class AggregateReleaseOptions {
        public static final AggregateReleaseOptions DEFAULT = new AggregateReleaseOptions(false);
        private final boolean overrideRelease;

        private AggregateReleaseOptions(boolean overrideRelease) {
            this.overrideRelease = overrideRelease;
        }

        public boolean overrideRelease() {
            return this.overrideRelease;
        }

        public static final class Builder {
            private boolean overrideRelease;

            public Builder overrideRelease(boolean overrideRelease) {
                this.overrideRelease = overrideRelease;
                return this;
            }

            public AggregateReleaseOptions build() {
                return new AggregateReleaseOptions(this.overrideRelease);
            }
        }
    }

    public static class MilestoneReleaseOptions {
        public static final MilestoneReleaseOptions DEFAULT = new MilestoneReleaseOptions(new ArrayList<String>(), false);
        private final List<String> ignoredLabels;
        private final boolean overrideRelease;

        private MilestoneReleaseOptions(List<String> ignoredLabels, boolean overrideRelease) {
            this.ignoredLabels = ignoredLabels;
            this.overrideRelease = overrideRelease;
        }

        public List<String> getIgnoredLabels() {
            return this.ignoredLabels;
        }

        public boolean overrideRelease() {
            return this.overrideRelease;
        }

        public String toString() {
            return "MilestoneReleaseOptions{ignoredLabels=" + this.ignoredLabels + ", overrideRelease=" + this.overrideRelease + '}';
        }

        public static final class Builder {
            private final List<String> ignoredLabels = new ArrayList<String>();
            private boolean overrideRelease;

            public Builder ignoreLabels(String ... labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(Arrays.asList(labels));
                return this;
            }

            public Builder ignoreLabels(List<String> labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(labels);
                return this;
            }

            public Builder overrideRelease(boolean overrideRelease) {
                this.overrideRelease = overrideRelease;
                return this;
            }

            public MilestoneReleaseOptions build() {
                return new MilestoneReleaseOptions(this.ignoredLabels, this.overrideRelease);
            }
        }
    }

    public static final class BranchReleaseOptions {
        public static final BranchReleaseOptions DEFAULT = new BranchReleaseOptions(new ArrayList<String>(), false, false);
        private final List<String> ignoredLabels;
        private final boolean overrideRelease;
        private final boolean includeIssuesWithoutClosingKeyword;

        private BranchReleaseOptions(List<String> ignoredLabels, boolean overrideRelease, boolean includeIssuesWithoutClosingKeyword) {
            this.ignoredLabels = ignoredLabels;
            this.overrideRelease = overrideRelease;
            this.includeIssuesWithoutClosingKeyword = includeIssuesWithoutClosingKeyword;
        }

        public List<String> getIgnoredLabels() {
            return this.ignoredLabels;
        }

        public boolean overrideRelease() {
            return this.overrideRelease;
        }

        public boolean includeIssuesWithoutClosingKeyword() {
            return this.includeIssuesWithoutClosingKeyword;
        }

        public String toString() {
            return "BranchReleaseOptions{ignoredLabels=" + this.ignoredLabels + ", overrideRelease=" + this.overrideRelease + ", includeIssuesWithoutClosingKeyword=" + this.includeIssuesWithoutClosingKeyword + '}';
        }

        public static final class Builder {
            private final List<String> ignoredLabels = new ArrayList<String>();
            private boolean overrideRelease;
            private boolean includeIssuesWithoutClosingKeyword;

            public Builder ignoreLabels(String ... labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(Arrays.asList(labels));
                return this;
            }

            public Builder ignoreLabels(List<String> labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(labels);
                return this;
            }

            public Builder overrideRelease(boolean overrideRelease) {
                this.overrideRelease = overrideRelease;
                return this;
            }

            public Builder includeIssuesWithoutClosingKeyword(boolean includeIssuesWithoutClosingKeyword) {
                this.includeIssuesWithoutClosingKeyword = includeIssuesWithoutClosingKeyword;
                return this;
            }

            public BranchReleaseOptions build() {
                return new BranchReleaseOptions(this.ignoredLabels, this.overrideRelease, this.includeIssuesWithoutClosingKeyword);
            }
        }
    }

    public static final class ReleaseResult {
        private final ReleaseNote releaseNote;
        private final URL releaseUrl;
        private final ReleaseException error;

        private ReleaseResult(ReleaseNote releaseNote, URL releaseUrl, ReleaseException error) {
            this.releaseNote = releaseNote;
            this.releaseUrl = releaseUrl;
            this.error = error;
        }

        public ReleaseNote getReleaseNote() {
            return this.releaseNote;
        }

        public URL getReleaseUrl() {
            return this.releaseUrl;
        }

        public ReleaseException getError() {
            return this.error;
        }

        public void throwIfFail() {
            if (this.isFail()) {
                throw this.error;
            }
        }

        public boolean isSuccess() {
            return this.error == null;
        }

        public boolean isFail() {
            return !this.isSuccess();
        }

        public static ReleaseResult success(ReleaseNote releaseNote, URL url) {
            Objects.requireNonNull(url);
            return new ReleaseResult(releaseNote, url, null);
        }

        public static ReleaseResult fail(ReleaseException error) {
            return new ReleaseResult(null, null, error);
        }

        public static ReleaseResult fail(Throwable error) {
            return ReleaseResult.fail(new ReleaseException(error.getMessage()));
        }

        public String toString() {
            return "ReleaseResult{releaseNote=" + this.releaseNote + ", releaseUrl=" + this.releaseUrl + ", error=" + this.error + '}';
        }
    }
}

