/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.openhft.chronicle.releasenotes.connector.ConnectorProvider;
import net.openhft.chronicle.releasenotes.connector.ConnectorProviderKey;
import net.openhft.chronicle.releasenotes.connector.MigrateConnector;
import net.openhft.chronicle.releasenotes.connector.ReleaseConnector;

public final class ConnectorProviderFactory {
    private static final ConnectorProviderFactory INSTANCE = new ConnectorProviderFactory();
    private final Map<Class<? extends ConnectorProviderKey>, ConnectorProvider<ReleaseConnector>> releaseConnectorProviders = new HashMap<Class<? extends ConnectorProviderKey>, ConnectorProvider<ReleaseConnector>>();
    private final Map<Class<? extends ConnectorProviderKey>, ConnectorProvider<MigrateConnector>> migrateConnectorProviders = new HashMap<Class<? extends ConnectorProviderKey>, ConnectorProvider<MigrateConnector>>();

    private ConnectorProviderFactory() {
    }

    public Optional<ConnectorProvider<ReleaseConnector>> getReleaseConnectorProvider(Class<? extends ConnectorProviderKey> connectorProviderKey) {
        Objects.requireNonNull(connectorProviderKey);
        return Optional.ofNullable(this.releaseConnectorProviders.get(connectorProviderKey));
    }

    public Optional<ConnectorProvider<MigrateConnector>> getMigrateConnectorProvider(Class<? extends ConnectorProviderKey> connectorProviderKey) {
        Objects.requireNonNull(connectorProviderKey);
        return Optional.ofNullable(this.migrateConnectorProviders.get(connectorProviderKey));
    }

    public void registerReleaseConnectorProvider(Class<? extends ConnectorProviderKey> connectorProviderKey, ConnectorProvider<ReleaseConnector> releaseConnector) {
        this.registerReleaseConnectorProvider(connectorProviderKey, releaseConnector, false);
    }

    public void registerReleaseConnectorProvider(Class<? extends ConnectorProviderKey> connectorProviderKey, ConnectorProvider<ReleaseConnector> releaseConnector, boolean override) {
        Objects.requireNonNull(connectorProviderKey);
        Objects.requireNonNull(releaseConnector);
        if (override) {
            this.releaseConnectorProviders.put(connectorProviderKey, releaseConnector);
        } else {
            this.releaseConnectorProviders.putIfAbsent(connectorProviderKey, releaseConnector);
        }
    }

    public void registerMigrateConnectorProvider(Class<? extends ConnectorProviderKey> connectorProviderKey, ConnectorProvider<MigrateConnector> migrateConnector) {
        this.registerMigrateConnectorProvider(connectorProviderKey, migrateConnector, false);
    }

    public void registerMigrateConnectorProvider(Class<? extends ConnectorProviderKey> connectorProviderKey, ConnectorProvider<MigrateConnector> migrateConnector, boolean override) {
        Objects.requireNonNull(connectorProviderKey);
        Objects.requireNonNull(migrateConnector);
        if (override) {
            this.migrateConnectorProviders.put(connectorProviderKey, migrateConnector);
        } else {
            this.migrateConnectorProviders.putIfAbsent(connectorProviderKey, migrateConnector);
        }
    }

    public static ConnectorProviderFactory getInstance() {
        return INSTANCE;
    }
}

