/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.HistoryReader;
import net.openhft.chronicle.queue.util.ToolsUtil;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMethodReader;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public class ChronicleHistoryReader
implements HistoryReader,
Closeable {
    private static final int SUMMARY_OUTPUT_UNSET = -999;
    public static final String SEPARATOR = "_";
    protected Path basePath;
    protected Consumer<String> messageSink;
    protected boolean progress = false;
    protected TimeUnit timeUnit = TimeUnit.NANOSECONDS;
    protected boolean histosByMethod = false;
    protected Map<String, Histogram> histos = new LinkedHashMap<String, Histogram>();
    protected long ignore = 0L;
    protected long counter = 0L;
    protected long measurementWindowNanos = 0L;
    protected long firstTimeStampNanos = 0L;
    protected long lastWindowCount = 0L;
    protected int summaryOutputOffset = -999;
    protected Long startIndex;
    protected Supplier<Histogram> histoSupplier = () -> new Histogram(60, 4);
    protected int lastHistosSize = 0;
    protected ExcerptTailer tailer;

    @Override
    public ChronicleHistoryReader withMessageSink(Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    @Override
    public ChronicleHistoryReader withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    @Override
    public ChronicleHistoryReader withProgress(boolean p) {
        this.progress = p;
        return this;
    }

    @Override
    public ChronicleHistoryReader withTimeUnit(TimeUnit p) {
        this.timeUnit = p;
        return this;
    }

    @Override
    public ChronicleHistoryReader withHistosByMethod(boolean b) {
        this.histosByMethod = b;
        return this;
    }

    @Override
    public ChronicleHistoryReader withIgnore(long ignore) {
        this.ignore = ignore;
        return this;
    }

    @Override
    public ChronicleHistoryReader withMeasurementWindow(long measurementWindow) {
        this.measurementWindowNanos = this.timeUnit.toNanos(measurementWindow);
        return this;
    }

    @Override
    public ChronicleHistoryReader withSummaryOutput(int offset) {
        this.summaryOutputOffset = offset;
        return this;
    }

    @Override
    public ChronicleHistoryReader withStartIndex(long startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @Override
    public ChronicleHistoryReader withHistoSupplier(Supplier<Histogram> histoSupplier) {
        this.histoSupplier = histoSupplier;
        return this;
    }

    @NotNull
    protected ChronicleQueue createQueue() {
        if (this.tailer != null && !this.tailer.queue().isClosed()) {
            return this.tailer.queue();
        }
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path %s does not exist", this.basePath));
        }
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(true).build();
        this.tailer = queue.createTailer();
        if (this.startIndex != null && !this.tailer.moveToIndex(this.startIndex)) {
            throw new IllegalArgumentException("Could not move to startIndex " + Long.toHexString(this.startIndex));
        }
        return queue;
    }

    @Override
    public void execute() {
        this.readChronicle();
        if (this.measurementWindowNanos == 0L) {
            this.outputData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Histogram> readChronicle() {
        this.createQueue();
        this.resetHistos();
        WireParselet parselet = this.parselet();
        FieldNumberParselet fieldNumberParselet = (methodId, wire) -> parselet.accept((CharSequence)this.methodIdToName(methodId), wire.read());
        MessageHistory prev = MessageHistory.get();
        MessageHistory.emptyHistory();
        try (VanillaMethodReader mr = new VanillaMethodReader((MarshallableIn)this.tailer, true, parselet, fieldNumberParselet, null, new Object[]{parselet});){
            while (!Thread.currentThread().isInterrupted() && mr.readOne()) {
                ++this.counter;
                if (!this.progress || this.counter % 1000000L != 0L) continue;
                Jvm.debug().on(this.getClass(), "Progress: " + this.counter);
            }
        }
        finally {
            MessageHistory.set((MessageHistory)prev);
        }
        return this.histos;
    }

    @NotNull
    protected String methodIdToName(long methodId) {
        return Long.toString(methodId);
    }

    @Override
    public void outputData() {
        if (this.summaryOutputOffset != -999) {
            this.printSummary();
        } else {
            this.printPercentilesSummary();
        }
    }

    private void printPercentilesSummary() {
        if (this.histos.size() == 0) {
            this.messageSink.accept("No data");
            return;
        }
        int counter = 0;
        this.messageSink.accept("Timings below in " + this.timeUnit.name());
        StringBuilder sb = new StringBuilder("sourceId        ");
        this.histos.forEach((id, histogram) -> sb.append(String.format("%12s ", id)));
        this.messageSink.accept(sb.toString());
        this.messageSink.accept("count:  " + this.count());
        this.messageSink.accept("50:     " + this.percentiles(counter++));
        this.messageSink.accept("90:     " + this.percentiles(counter++));
        this.messageSink.accept("99:     " + this.percentiles(counter++));
        this.messageSink.accept("99.9:   " + this.percentiles(counter++));
        this.messageSink.accept("99.99:  " + this.percentiles(counter++));
        this.messageSink.accept("99.999: " + this.percentiles(counter++));
        this.messageSink.accept("99.9999:" + this.percentiles(counter++));
        this.messageSink.accept("worst:  " + this.percentiles(-1));
    }

    private void printSummary() {
        if (this.histos.size() > this.lastHistosSize) {
            this.messageSink.accept("relative_ts," + String.join((CharSequence)",", this.histos.keySet()));
            this.lastHistosSize = this.histos.size();
        }
        long tsSinceStart = this.lastWindowCount * this.measurementWindowNanos - this.firstTimeStampNanos;
        this.messageSink.accept(this.timeUnit.convert(tsSinceStart, TimeUnit.NANOSECONDS) + "," + this.histos.values().stream().map(h -> Long.toString(this.timeUnit.convert((long)this.offset(h.getPercentiles(), this.summaryOutputOffset), TimeUnit.NANOSECONDS))).collect(Collectors.joining(",")));
    }

    private double offset(double[] percentiles, int offset) {
        return offset >= 0 ? percentiles[offset] : percentiles[percentiles.length + offset];
    }

    private String count() {
        StringBuilder sb = new StringBuilder("        ");
        this.histos.forEach((id, histogram) -> sb.append(String.format("%12d ", histogram.totalCount())));
        return sb.toString();
    }

    private String percentiles(int index) {
        StringBuilder sb = new StringBuilder("        ");
        this.histos.forEach((id, histogram) -> {
            double[] percentiles = histogram.getPercentiles();
            if (index >= percentiles.length - 1) {
                sb.append(String.format("%12s ", " "));
                return;
            }
            int myIndex = index;
            if (myIndex == -1) {
                myIndex = percentiles.length - 1;
            }
            double value = percentiles[myIndex];
            sb.append(String.format("%12d ", this.timeUnit.convert((long)value, TimeUnit.NANOSECONDS)));
        });
        return sb.toString();
    }

    protected WireParselet parselet() {
        return (methodName, v) -> {
            v.skipValue();
            if (this.counter < this.ignore) {
                return;
            }
            MessageHistory history = MessageHistory.get();
            if (history == null) {
                return;
            }
            this.processMessage(methodName, history);
            if (history.timings() > 0) {
                long firstTiming = history.timing(0);
                if (this.measurementWindowNanos > 0L) {
                    long windowCount = firstTiming / this.measurementWindowNanos;
                    if (windowCount > this.lastWindowCount) {
                        this.windowPassed();
                        this.lastWindowCount = windowCount;
                    }
                    if (this.firstTimeStampNanos == 0L) {
                        this.firstTimeStampNanos = firstTiming;
                    }
                }
            }
        };
    }

    protected void processMessage(CharSequence methodName, MessageHistory history) {
        String extraHistoId = this.histosByMethod ? SEPARATOR + methodName : "";
        long lastTime = 0L;
        int firstWriteOffset = history.timings() - history.sources() * 2;
        if (firstWriteOffset != 0 && firstWriteOffset != 1) {
            Jvm.warn().on(this.getClass(), "firstWriteOffset is not 0 or 1 for " + history);
            return;
        }
        for (int sourceIndex = 0; sourceIndex < history.sources(); ++sourceIndex) {
            Histogram histo1;
            String histoId = Integer.toString(history.sourceId(sourceIndex)) + extraHistoId;
            Histogram histo = this.histos.computeIfAbsent(histoId, s -> this.histogram());
            long receivedByThisComponent = history.timing(2 * sourceIndex + firstWriteOffset);
            long processedByThisComponent = history.timing(2 * sourceIndex + firstWriteOffset + 1);
            histo.sample((double)(processedByThisComponent - receivedByThisComponent));
            if (lastTime == 0L && firstWriteOffset > 0) {
                histo1 = this.histos.computeIfAbsent("startTo" + histoId, s -> this.histogram());
                histo1.sample((double)(receivedByThisComponent - history.timing(0)));
            } else if (lastTime != 0L) {
                histo1 = this.histos.computeIfAbsent(history.sourceId(sourceIndex - 1) + "to" + histoId, s -> this.histogram());
                histo1.sample((double)(receivedByThisComponent - lastTime));
            }
            lastTime = processedByThisComponent;
        }
        if (history.sources() > 1) {
            Histogram histoE2E = this.histos.computeIfAbsent("endToEnd", s -> this.histogram());
            histoE2E.sample((double)(history.timing(history.timings() - 1) - history.timing(0)));
        }
    }

    protected void windowPassed() {
        this.outputData();
        this.resetHistos();
    }

    private void resetHistos() {
        this.histos.values().forEach(Histogram::reset);
    }

    @NotNull
    protected Histogram histogram() {
        return this.histoSupplier.get();
    }

    @Override
    public void close() {
        if (this.tailer != null) {
            this.tailer.queue().close();
        }
    }

    static {
        ToolsUtil.warnIfResourceTracing();
    }
}

