/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.domestic;

import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.function.Function;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.jetbrains.annotations.NotNull;

public final class QueueOffsetSpec {
    private static final String TOKEN_DELIMITER = ";";
    private final Type type;
    private final String[] spec;

    private QueueOffsetSpec(Type type, String[] spec) {
        this.type = type;
        this.spec = spec;
    }

    public static QueueOffsetSpec ofEpoch(long epoch) {
        return new QueueOffsetSpec(Type.EPOCH, new String[]{Long.toString(epoch)});
    }

    public static QueueOffsetSpec ofRollTime(@NotNull LocalTime time, @NotNull ZoneId zoneId) {
        return new QueueOffsetSpec(Type.ROLL_TIME, new String[]{time.toString(), zoneId.toString()});
    }

    public static QueueOffsetSpec ofNone() {
        return new QueueOffsetSpec(Type.NONE, new String[0]);
    }

    public static QueueOffsetSpec parse(@NotNull String definition) {
        String[] tokens = definition.split(TOKEN_DELIMITER);
        Type type = Type.valueOf(tokens[0]);
        switch (type) {
            case EPOCH: {
                QueueOffsetSpec.expectArgs(tokens, 2);
                return new QueueOffsetSpec(type, new String[]{tokens[1]});
            }
            case ROLL_TIME: {
                QueueOffsetSpec.expectArgs(tokens, 3);
                return new QueueOffsetSpec(type, new String[]{tokens[1], tokens[2]});
            }
            case NONE: {
                QueueOffsetSpec.expectArgs(tokens, 1);
                return new QueueOffsetSpec(type, new String[0]);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    public static String formatEpochOffset(long epochOffset) {
        return String.format("%s;%s", Type.EPOCH.name(), epochOffset);
    }

    public static String formatRollTime(LocalTime time, ZoneId zoneId) {
        return String.format("%s;%s;%s", Type.ROLL_TIME.name(), time.toString(), zoneId.toString());
    }

    public static String formatNone() {
        return Type.NONE.name();
    }

    private static ZoneId toZoneId(String zoneId) {
        return ZoneId.of(zoneId);
    }

    private static LocalTime toLocalTime(String timestamp) {
        return LocalTime.parse(timestamp);
    }

    private static void expectArgs(String[] tokens, int expectedLength) {
        if (tokens.length != expectedLength) {
            throw new IllegalArgumentException("Expected " + expectedLength + " tokens in " + Arrays.toString(tokens));
        }
    }

    public void apply(SingleChronicleQueueBuilder builder) {
        switch (this.type) {
            case EPOCH: {
                builder.epoch(Long.parseLong(this.spec[0]));
                break;
            }
            case ROLL_TIME: {
                builder.rollTime(QueueOffsetSpec.toLocalTime(this.spec[0]), QueueOffsetSpec.toZoneId(this.spec[1]));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
            }
        }
    }

    public String format() {
        return this.type.name() + TOKEN_DELIMITER + (String)this.type.argFormatter.apply(this.spec);
    }

    public void validate() {
        switch (this.type) {
            case EPOCH: {
                Long.parseLong(this.spec[0]);
                break;
            }
            case ROLL_TIME: {
                QueueOffsetSpec.toLocalTime(this.spec[0]);
                QueueOffsetSpec.toZoneId(this.spec[1]);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
            }
        }
    }

    public static enum Type {
        EPOCH(args -> args[0]),
        ROLL_TIME(args -> args[0] + QueueOffsetSpec.TOKEN_DELIMITER + args[1]),
        NONE(args -> "");

        private final Function<String[], String> argFormatter;

        private Type(Function<String[], String> argFormatter) {
            this.argFormatter = argFormatter;
        }
    }
}

