/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.RollCycleEncodeSequence;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
extends AbstractCloseable
implements WireStore {
    @NotNull
    final SCQIndexing indexing;
    @NotNull
    private final LongValue writePosition;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    private final int dataVersion;
    @NotNull
    private final transient Sequence sequence;
    private int cycle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedViaReflection
    private SingleChronicleQueueStore(@NotNull WireIn wire) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        boolean failed = true;
        try {
            this.writePosition = this.loadWritePosition(wire);
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.mappedFile.reserve((ReferenceOwner)this);
            this.indexing = (SCQIndexing)Objects.requireNonNull(wire.read((WireKey)MetaDataField.indexing).typedMarshallable());
            this.indexing.writePosition = this.writePosition;
            this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, this.indexing.indexCount(), this.indexing.indexSpacing());
            String fieldName = (String)wire.readEvent(String.class);
            int version = 0;
            if (fieldName == null || ((String)MetaDataField.dataFormat.name()).equals(fieldName)) {
                version = wire.getValueIn().int32();
            } else {
                Jvm.warn().on(this.getClass(), "Unexpected field " + fieldName);
            }
            this.dataVersion = version > 1 ? 0 : version;
            this.singleThreadedCheckDisabled(true);
            failed = false;
        }
        finally {
            if (failed) {
                this.close();
            }
        }
    }

    public SingleChronicleQueueStore(@NotNull RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, int indexCount, int indexSpacing) {
        if (rollCycle == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollCycle') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        if (mappedBytes == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'mappedBytes') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        if (rollCycle == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollCycle') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        if (mappedBytes == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'mappedBytes') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.<init> must not be null");
        }
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.mappedFile.reserve((ReferenceOwner)this);
        indexCount = Maths.nextPower2((int)indexCount, (int)8);
        indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.indexing = new SCQIndexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newTwoLongReference().get();
        this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, rollCycle.defaultIndexCount(), rollCycle.defaultIndexSpacing());
        this.dataVersion = 1;
        this.singleThreadedCheckDisabled(true);
    }

    @NotNull
    public static String dump(@NotNull String directoryFilePath) {
        if (directoryFilePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'directoryFilePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.dump must not be null");
        }
        if (directoryFilePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'directoryFilePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.dump must not be null");
        }
        String string = ChronicleQueue.singleBuilder(directoryFilePath).build().dump();
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.dump must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.dump must not return null");
        }
        return string;
    }

    private static WireOut intForBinding(ValueOut wireOut, LongValue value) {
        return value instanceof TwoLongValue ? wireOut.int128forBinding(0L, 0L, (TwoLongValue)value) : wireOut.int64forBinding(0L, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongValue loadWritePosition(@NotNull WireIn wire) {
        int code;
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.loadWritePosition must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.loadWritePosition must not be null");
        }
        ValueIn read = wire.read((WireKey)MetaDataField.writePosition);
        long start = wire.bytes().readPosition();
        try {
            wire.consumePadding();
            code = wire.bytes().uncheckedReadUnsignedByte();
        }
        finally {
            wire.bytes().readPosition(start);
        }
        if (code == 141) {
            TwoLongValue result = wire.newTwoLongReference();
            read.int128(result);
            return result;
        }
        LongValue result = wire.newLongReference();
        read.int64(result);
        return result;
    }

    @Override
    @NotNull
    public File file() {
        File file = this.mappedFile.file();
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.file must not return null");
        }
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.file must not return null");
        }
        return file;
    }

    @Override
    @NotNull
    public String dump() {
        String string = this.dump(WireType.BINARY_LIGHT, false);
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.dump must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.dump must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String shortDump() {
        String string = this.dump(WireType.BINARY_LIGHT, true);
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.shortDump must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.shortDump must not return null");
        }
        return string;
    }

    @Override
    public String dump(WireType wireType) {
        return this.dump(wireType, false);
    }

    private String dump(WireType wireType, boolean abbrev) {
        try (MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);){
            bytes.readLimit(bytes.realCapacity());
            Wire w = (Wire)wireType.apply((Object)bytes);
            w.usePadding(this.dataVersion > 0);
            String string = Wires.fromSizePrefixedBlobs((WireIn)w, (boolean)abbrev);
            return string;
        }
    }

    @Override
    public String dumpHeader() {
        try (MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);){
            int size = bytes.readInt(0L);
            if (!Wires.isReady((int)size)) {
                String string = "not ready";
                return string;
            }
            bytes.readLimit((long)Wires.lengthOf((int)size) + 4L);
            String string = Wires.fromSizePrefixedBlobs((Bytes)bytes);
            return string;
        }
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    @NotNull
    public WireStore writePosition(long position) {
        this.throwExceptionIfClosed();
        assert (this.writePosition.getVolatileValue() + this.mappedFile.chunkSize() > position);
        this.writePosition.setMaxValue(position);
        SingleChronicleQueueStore singleChronicleQueueStore = this;
        if (singleChronicleQueueStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writePosition must not return null");
        }
        if (singleChronicleQueueStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writePosition must not return null");
        }
        return singleChronicleQueueStore;
    }

    @Override
    @Nullable
    public ScanResult moveToIndexForRead(@NotNull ExcerptContext ec, long index) {
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.moveToIndexForRead must not be null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.moveToIndexForRead must not be null");
        }
        this.throwExceptionIfClosed();
        try {
            return this.indexing.moveToIndex(ec, index);
        }
        catch (UnrecoverableTimeoutException e) {
            return ScanResult.NOT_REACHED;
        }
    }

    @Override
    @Nullable
    public ScanResult moveToStartForRead(@NotNull ExcerptContext ec) {
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.moveToStartForRead must not be null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.moveToStartForRead must not be null");
        }
        this.throwExceptionIfClosed();
        Wire wire = ec.wire();
        wire.bytes().readPositionUnlimited(0L);
        try {
            WireIn.HeaderType headerType = wire.readDataHeader(true);
            switch (headerType) {
                case DATA: 
                case META_DATA: {
                    return ScanResult.FOUND;
                }
                case NONE: {
                    return ScanResult.NOT_REACHED;
                }
                case EOF: {
                    return ScanResult.END_OF_FILE;
                }
            }
            throw new AssertionError((Object)("headerType=" + headerType));
        }
        catch (EOFException eof) {
            return ScanResult.END_OF_FILE;
        }
    }

    @Override
    public long moveToEndForRead(@NotNull Wire w) {
        if (w == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'w') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.moveToEndForRead must not be null");
        }
        if (w == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'w') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.moveToEndForRead must not be null");
        }
        this.throwExceptionIfClosed();
        return this.indexing.moveToEnd(w);
    }

    protected void performClose() {
        Closeable.closeQuietly((Object)this.writePosition);
        Closeable.closeQuietly((Object)this.indexing);
        if (this.mappedBytes != null) {
            this.mappedBytes.release(INIT);
            try {
                this.mappedFile.release((ReferenceOwner)this);
            }
            catch (IllegalStateException e) {
                Jvm.warn().on(this.getClass(), "trouble releasing " + this.mappedFile, (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        this.throwExceptionIfClosed();
        MappedBytes mbytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        mbytes.singleThreadedCheckDisabled(true);
        MappedBytes mappedBytes = mbytes;
        if (mappedBytes == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.bytes must not return null");
        }
        if (mappedBytes == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.bytes must not return null");
        }
        return mappedBytes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long sequenceForPosition(@NotNull ExcerptContext ec, long position, boolean bl) throws StreamCorruptedException {
        void inclusive;
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.sequenceForPosition must not be null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.sequenceForPosition must not be null");
        }
        this.throwExceptionIfClosed();
        return this.indexing.sequenceForPosition(ec, position, (boolean)inclusive);
    }

    public long approximateLastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.approximateLastSequenceNumber must not be null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.approximateLastSequenceNumber must not be null");
        }
        this.throwExceptionIfClosedInSetter();
        return this.indexing.lastSequenceNumber(ec, true);
    }

    public long exactLastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.exactLastSequenceNumber must not be null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.exactLastSequenceNumber must not be null");
        }
        this.throwExceptionIfClosedInSetter();
        return this.indexing.lastSequenceNumber(ec, false);
    }

    @NotNull
    public String toString() {
        String string = "SingleChronicleQueueStore{indexing=" + this.indexing + ", writePosition/seq=" + this.writePosition + ", mappedFile=" + this.mappedFile + ", isClosed=" + this.isClosed() + '}';
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.toString must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.toString must not return null");
        }
        return string;
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writeMarshallable must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writeMarshallable must not be null");
        }
        ValueOut wireOut = wire.write((WireKey)MetaDataField.writePosition);
        SingleChronicleQueueStore.intForBinding(wireOut, this.writePosition).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing).write((WireKey)MetaDataField.dataFormat).int32(this.dataVersion);
    }

    @Override
    public void initIndex(@NotNull Wire wire) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.initIndex must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.initIndex must not be null");
        }
        this.throwExceptionIfClosedInSetter();
        try {
            this.indexing.initIndex(wire);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean indexable(long index) {
        return this.indexing.indexable(index);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPositionForSequenceNumber(@NotNull ExcerptContext ec, long sequenceNumber, long l) throws StreamCorruptedException {
        void position;
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.setPositionForSequenceNumber must not be null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'ec') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.setPositionForSequenceNumber must not be null");
        }
        this.throwExceptionIfClosedInSetter();
        this.sequence.setSequence(sequenceNumber, (long)position);
        long nextSequence = this.indexing.nextEntryToBeIndexed();
        if (nextSequence > sequenceNumber) {
            return;
        }
        this.indexing.setPositionForSequenceNumber(ec, sequenceNumber, (long)position);
    }

    @Override
    public ScanResult linearScanTo(long index, long knownIndex, ExcerptContext ec, long knownAddress) {
        this.throwExceptionIfClosed();
        return this.indexing.linearScanTo(index, knownIndex, ec, knownAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeEOF(@NotNull Wire wire, long timeoutMS) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writeEOF must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writeEOF must not be null");
        }
        this.throwExceptionIfClosed();
        String fileName = this.mappedFile.file().getAbsolutePath();
        if (wire.bytes().tryReserve((ReferenceOwner)this)) {
            try {
                boolean bl2 = this.writeEOFAndShrink(wire, timeoutMS);
                return bl2;
            }
            finally {
                wire.bytes().release((ReferenceOwner)this);
            }
        }
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)this.mappedFile.file(), (long)this.mappedFile.chunkSize());){
            Wire wire0 = (Wire)WireType.valueOf((Wire)wire).apply((Object)bytes);
            boolean bl = this.writeEOFAndShrink(wire0, timeoutMS);
            return bl;
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "unable to write the EOF file=" + fileName, (Throwable)e);
            return false;
        }
    }

    boolean writeEOFAndShrink(@NotNull Wire wire, long timeoutMS) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writeEOFAndShrink must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueStore.writeEOFAndShrink must not be null");
        }
        return wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, this.writePosition());
    }

    @Override
    public int dataVersion() {
        return this.dataVersion;
    }

    public SingleChronicleQueueStore cycle(int cycle) {
        this.throwExceptionIfClosedInSetter();
        this.cycle = cycle;
        return this;
    }

    public int cycle() {
        return this.cycle;
    }

    public File currentFile() {
        return this.mappedFile.file();
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{SCQIndexing.class});
    }
}

