/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.crypto.spec.SecretKeySpec;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.OnDemandEventLoop;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Builder;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingBiFunction;
import net.openhft.chronicle.core.util.Updater;
import net.openhft.chronicle.queue.AppenderListener;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.StoreFileListeners;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.AsyncBufferCreator;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.NoOpCondition;
import net.openhft.chronicle.queue.impl.single.ReadOnlyWriteLock;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQMeta;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.ReadonlyTableStore;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.queue.internal.domestic.QueueOffsetSpec;
import net.openhft.chronicle.threads.MediumEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueBuilder
extends SelfDescribingMarshallable
implements Cloneable,
Builder<SingleChronicleQueue> {
    public static final long SMALL_BLOCK_SIZE;
    public static final long DEFAULT_SPARSE_CAPACITY = 0x8000000000L;
    private static final Constructor ENTERPRISE_QUEUE_CONSTRUCTOR;
    private static final WireStoreFactory storeFactory;
    private static final Supplier<TimingPauser> TIMING_PAUSER_SUPPLIER;
    private BufferMode writeBufferMode = BufferMode.None;
    private BufferMode readBufferMode = BufferMode.None;
    private WireType wireType = WireType.BINARY_LIGHT;
    private Long blockSize;
    @Deprecated
    private Boolean useSparseFiles;
    private Long sparseCapacity;
    private File path;
    private RollCycle rollCycle;
    private Long epoch;
    private Long bufferCapacity;
    private Integer indexSpacing;
    private Integer indexCount;
    private Boolean enableRingBufferMonitoring;
    private Boolean ringBufferReaderCanDrain;
    private Boolean ringBufferForceCreateReader;
    private Boolean ringBufferReopenReader;
    private Supplier<Pauser> ringBufferPauserSupplier;
    private HandlerPriority drainerPriority;
    private int drainerTimeoutMS = -1;
    @Nullable
    private EventLoop eventLoop;
    private Consumer<BytesRingBufferStats> onRingBufferStats;
    private TimeProvider timeProvider;
    private Supplier<TimingPauser> pauserSupplier;
    private Long timeoutMS;
    private Integer sourceId;
    private StoreFileListener storeFileListener;
    private Boolean readOnly;
    private boolean checkInterrupts;
    private transient TableStore<SCQMeta> metaStore;
    private int deltaCheckpointInterval = -1;
    private Supplier<BiConsumer<BytesStore, Bytes<?>>> encodingSupplier;
    private Supplier<BiConsumer<BytesStore, Bytes<?>>> decodingSupplier;
    private Updater<Bytes<?>> messageInitializer;
    private Consumer<Bytes<?>> messageHeaderReader;
    private SecretKeySpec key;
    private int maxTailers;
    private ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator;
    private Long pretouchIntervalMillis;
    private LocalTime rollTime;
    private ZoneId rollTimeZone;
    private QueueOffsetSpec queueOffsetSpec;
    private boolean doubleBuffer;
    private Function<SingleChronicleQueue, Condition> createAppenderConditionCreator;
    private long forceDirectoryListingRefreshIntervalMs = 60000L;
    private AppenderListener appenderListener;
    private SyncMode syncMode;

    protected SingleChronicleQueueBuilder() {
    }

    public static void addAliases() {
    }

    public static SingleChronicleQueueBuilder builder() {
        return new SingleChronicleQueueBuilder();
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull Path path, @NotNull WireType wireType) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = SingleChronicleQueueBuilder.builder(path.toFile(), wireType);
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not be null");
        }
        SingleChronicleQueueBuilder result = SingleChronicleQueueBuilder.builder().wireType(wireType);
        if (file.isFile()) {
            if (!file.getName().endsWith(".cq4")) {
                throw new IllegalArgumentException("Invalid file type: " + file.getName());
            }
            Jvm.warn().on(SingleChronicleQueueBuilder.class, "Queues should be configured with the queue directory, not a specific filename. Actual file used: " + file.getParentFile());
            result.path(file.getParentFile());
        } else {
            result.path(file);
        }
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = result;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.builder must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    public static SingleChronicleQueueBuilder single() {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.builder();
        builder.wireType(WireType.BINARY_LIGHT);
        return builder;
    }

    public static SingleChronicleQueueBuilder single(@NotNull String basePath) {
        if (basePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.single must not be null");
        }
        if (basePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.single must not be null");
        }
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    public static SingleChronicleQueueBuilder single(@NotNull File basePath) {
        if (basePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.single must not be null");
        }
        if (basePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.single must not be null");
        }
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    public static SingleChronicleQueueBuilder binary(@NotNull Path path) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.binary must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.binary must not be null");
        }
        return SingleChronicleQueueBuilder.binary(path.toFile());
    }

    public static SingleChronicleQueueBuilder binary(@NotNull String basePath) {
        if (basePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.binary must not be null");
        }
        if (basePath == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePath') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.binary must not be null");
        }
        return SingleChronicleQueueBuilder.binary(new File(basePath));
    }

    public static SingleChronicleQueueBuilder binary(@NotNull File basePathFile) {
        if (basePathFile == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePathFile') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.binary must not be null");
        }
        if (basePathFile == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePathFile') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.binary must not be null");
        }
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.BINARY_LIGHT);
    }

    @NotNull
    static SingleChronicleQueueStore createStore(@NotNull RollingChronicleQueue queue, @NotNull Wire wire) {
        if (queue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createStore must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createStore must not be null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createStore must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wire') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createStore must not be null");
        }
        MappedBytes mappedBytes = (MappedBytes)wire.bytes();
        SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(queue.rollCycle(), queue.wireType(), mappedBytes, queue.indexCount(), queue.indexSpacing());
        wire.writeEventName((WireKey)MetaDataKeys.header).typedMarshallable((WriteMarshallable)wireStore);
        SingleChronicleQueueStore singleChronicleQueueStore = wireStore;
        if (singleChronicleQueueStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createStore must not return null");
        }
        if (singleChronicleQueueStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createStore must not return null");
        }
        return singleChronicleQueueStore;
    }

    public static boolean areEnterpriseFeaturesAvailable() {
        return ENTERPRISE_QUEUE_CONSTRUCTOR != null;
    }

    private static RollCycle loadDefaultRollCycle() {
        String rollCycleProperty = Jvm.getProperty((String)"net.openhft.queue.builder.defaultRollCycle");
        if (null == rollCycleProperty) {
            return RollCycles.DEFAULT;
        }
        String[] rollCyclePropertyParts = rollCycleProperty.split(":");
        if (rollCyclePropertyParts.length > 0) {
            try {
                Class<?> rollCycleClass = Class.forName(rollCyclePropertyParts[0]);
                if (Enum.class.isAssignableFrom(rollCycleClass)) {
                    if (rollCyclePropertyParts.length < 2) {
                        Jvm.warn().on(SingleChronicleQueueBuilder.class, "Default roll cycle configured as enum, but enum value not specified: " + rollCycleProperty);
                    } else {
                        Class<?> eClass = rollCycleClass;
                        Enum instance = ObjectUtils.valueOfIgnoreCase(eClass, (String)rollCyclePropertyParts[1]);
                        if (instance instanceof RollCycle) {
                            return RollCycles.warnIfDeprecated((RollCycle)((Object)instance));
                        }
                        Jvm.warn().on(SingleChronicleQueueBuilder.class, "Configured default rollcycle is not a subclass of RollCycle");
                    }
                } else {
                    Object instance = ObjectUtils.newInstance(rollCycleClass);
                    if (instance instanceof RollCycle) {
                        return (RollCycle)instance;
                    }
                    Jvm.warn().on(SingleChronicleQueueBuilder.class, "Configured default rollcycle is not a subclass of RollCycle");
                }
            }
            catch (ClassNotFoundException ignored) {
                Jvm.warn().on(SingleChronicleQueueBuilder.class, "Default roll cycle class: " + rollCyclePropertyParts[0] + " was not found");
            }
        }
        return RollCycles.DEFAULT;
    }

    public WireStoreFactory storeFactory() {
        return storeFactory;
    }

    @NotNull
    public SingleChronicleQueue build() {
        this.preBuild();
        if (Boolean.TRUE.equals(this.useSparseFiles) && this.sparseCapacity == null && (this.rollCycle == null || this.rollCycle.lengthInMillis() > 60000)) {
            RollCycle rc = this.rollCycle == null ? RollCycles.FAST_DAILY : this.rollCycle;
            long msgs = rc.maxMessagesPerCycle();
            this.sparseCapacity = Math.min(0x8000000000L, Math.max(0x100000000L, msgs * 128L));
            this.useSparseFiles = true;
        }
        SingleChronicleQueue chronicleQueue = this.checkEnterpriseFeaturesRequested() ? this.buildEnterprise() : new SingleChronicleQueue(this);
        this.postBuild(chronicleQueue);
        SingleChronicleQueue singleChronicleQueue = chronicleQueue;
        if (singleChronicleQueue == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.build must not return null");
        }
        if (singleChronicleQueue == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.build must not return null");
        }
        return singleChronicleQueue;
    }

    private void postBuild(@NotNull SingleChronicleQueue chronicleQueue) {
        if (chronicleQueue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'chronicleQueue') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.postBuild must not be null");
        }
        if (chronicleQueue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'chronicleQueue') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.postBuild must not be null");
        }
        if (!this.readOnly()) {
            chronicleQueue.createAppenderCondition(Objects.requireNonNull(this.createAppenderConditionCreator().apply(chronicleQueue)));
        }
    }

    private boolean checkEnterpriseFeaturesRequested() {
        boolean result = false;
        if (this.readBufferMode != BufferMode.None) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Buffering");
        }
        if (this.writeBufferMode != BufferMode.None) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Buffering");
        }
        if (this.rollTimeZone != null && !this.rollTimeZone.getId().equals("UTC") && !this.rollTimeZone.getId().equals("Z")) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Non-UTC roll time zone");
        }
        if (this.wireType == WireType.DELTA_BINARY) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Wire type " + this.wireType.name());
        }
        if (this.encodingSupplier != null) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Encoding");
        }
        if (this.key != null) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Encryption");
        }
        if (this.hasPretouchIntervalMillis()) {
            result = SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Out of process pretouching");
        }
        return result;
    }

    public static boolean onlyAvailableInEnterprise(String feature) {
        if (ENTERPRISE_QUEUE_CONSTRUCTOR == null) {
            Jvm.warn().on(SingleChronicleQueueBuilder.class, feature + " is only supported in Chronicle Queue Enterprise. If you would like to use this feature, please contact sales@chronicle.software for more information.");
        }
        return true;
    }

    @NotNull
    private SingleChronicleQueue buildEnterprise() {
        SingleChronicleQueue singleChronicleQueue;
        if (ENTERPRISE_QUEUE_CONSTRUCTOR == null) {
            throw new IllegalStateException("Enterprise features requested but Chronicle Queue Enterprise is not in the class path!");
        }
        try {
            singleChronicleQueue = (SingleChronicleQueue)ENTERPRISE_QUEUE_CONSTRUCTOR.newInstance(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't create an instance of Enterprise queue", e);
        }
        if (singleChronicleQueue == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.buildEnterprise must not return null");
        }
        if (singleChronicleQueue == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.buildEnterprise must not return null");
        }
        return singleChronicleQueue;
    }

    public SingleChronicleQueueBuilder aesEncryption(@Nullable byte[] keyBytes) {
        if (keyBytes == null) {
            this.codingSuppliers(null, null);
            return this;
        }
        this.key = new SecretKeySpec(keyBytes, "AES");
        return this;
    }

    public Updater<Bytes<?>> messageInitializer() {
        return this.messageInitializer == null ? Bytes::clear : this.messageInitializer;
    }

    public Consumer<Bytes<?>> messageHeaderReader() {
        return this.messageHeaderReader == null ? b -> {} : this.messageHeaderReader;
    }

    public SingleChronicleQueueBuilder messageHeader(Updater<Bytes<?>> messageInitializer, Consumer<Bytes<?>> messageHeaderReader) {
        this.messageInitializer = messageInitializer;
        this.messageHeaderReader = messageHeaderReader;
        return this;
    }

    public SingleChronicleQueueBuilder rollTime(@NotNull LocalTime rollTime) {
        if (rollTime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollTime') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTime must not be null");
        }
        if (rollTime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollTime') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTime must not be null");
        }
        this.rollTime(rollTime, this.rollTimeZone);
        return this;
    }

    public ZoneId rollTimeZone() {
        return this.rollTimeZone;
    }

    public SingleChronicleQueueBuilder rollTimeZone(@NotNull ZoneId rollTimeZone) {
        if (rollTimeZone == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollTimeZone') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTimeZone must not be null");
        }
        if (rollTimeZone == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollTimeZone') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTimeZone must not be null");
        }
        this.rollTime(this.rollTime, rollTimeZone);
        return this;
    }

    public SingleChronicleQueueBuilder rollTime(@NotNull LocalTime rollTime, @NotNull ZoneId zoneId) {
        if (rollTime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollTime') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTime must not be null");
        }
        if (zoneId == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'zoneId') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTime must not be null");
        }
        if (rollTime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollTime') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTime must not be null");
        }
        if (zoneId == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'zoneId') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollTime must not be null");
        }
        this.rollTime = rollTime;
        this.rollTimeZone = zoneId;
        this.epoch = TimeUnit.SECONDS.toMillis(rollTime.toSecondOfDay());
        this.queueOffsetSpec = QueueOffsetSpec.ofRollTime(rollTime, zoneId);
        return this;
    }

    protected void initializeMetadata() {
        File metapath = this.metapath();
        this.validateRollCycle(metapath);
        SCQMeta metadata = new SCQMeta(new SCQRoll(this.rollCycle(), this.epoch(), this.rollTime, this.rollTimeZone), this.deltaCheckpointInterval(), this.sourceId());
        try {
            boolean readOnly = this.readOnly();
            this.metaStore = SingleTableBuilder.binary(metapath, metadata).readOnly(readOnly).build();
            SCQMeta newMeta = this.metaStore.metadata();
            this.sourceId(newMeta.sourceId());
            String format = newMeta.roll().format();
            if (!format.equals(this.rollCycle().format())) {
                this.overrideRollCycleForFileName(format);
            }
            this.rollTime = newMeta.roll().rollTime();
            this.rollTimeZone = newMeta.roll().rollTimeZone();
            this.epoch = newMeta.roll().epoch();
        }
        catch (IORuntimeException ex) {
            if (OS.isWindows()) {
                throw ex;
            }
            if (ex.getMessage().equals("Metadata file not found in readOnly mode")) {
                Jvm.warn().on(this.getClass(), "Failback to readonly tablestore " + (Object)((Object)ex));
            } else {
                Jvm.warn().on(this.getClass(), "Failback to readonly tablestore", (Throwable)ex);
            }
            this.metaStore = new ReadonlyTableStore<SCQMeta>(metadata);
        }
    }

    private void validateRollCycle(File metapath) {
        String[] list;
        if (!metapath.exists() && (list = this.path.list((d, name) -> name.endsWith(".cq4"))) != null && list.length > 0) {
            String filename = list[0];
            for (RollCycle cycle : RollCycles.all()) {
                try {
                    DateTimeFormatter.ofPattern(cycle.format()).parse(filename.substring(0, filename.length() - 4));
                    this.overrideRollCycle(cycle);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private void overrideRollCycleForFileName(String pattern) {
        for (RollCycle cycle : RollCycles.all()) {
            if (!cycle.format().equals(pattern)) continue;
            this.overrideRollCycle(cycle);
            return;
        }
        throw new IllegalStateException("Can't find an appropriate RollCycles to override to of length " + pattern);
    }

    private void overrideRollCycle(RollCycle cycle) {
        if (this.rollCycle != cycle && this.rollCycle != null) {
            Jvm.warn().on(this.getClass(), "Overriding roll cycle from " + this.rollCycle + " to " + cycle);
        }
        this.rollCycle = cycle;
    }

    private File metapath() {
        File storeFilePath;
        if ("".equals(this.path.getPath())) {
            storeFilePath = new File("metadata.cq4t");
        } else {
            storeFilePath = new File(this.path, "metadata.cq4t");
            this.path.mkdirs();
        }
        return storeFilePath;
    }

    @NotNull
    public Function<SingleChronicleQueue, Condition> createAppenderConditionCreator() {
        if (this.createAppenderConditionCreator == null) {
            Function<SingleChronicleQueue, Condition> function = q -> NoOpCondition.INSTANCE;
            if (function == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createAppenderConditionCreator must not return null");
            }
            if (function == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createAppenderConditionCreator must not return null");
            }
            return function;
        }
        Function<SingleChronicleQueue, Condition> function = this.createAppenderConditionCreator;
        if (function == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createAppenderConditionCreator must not return null");
        }
        if (function == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createAppenderConditionCreator must not return null");
        }
        return function;
    }

    @NotNull
    public SingleChronicleQueueBuilder createAppenderConditionCreator(Function<SingleChronicleQueue, Condition> creator) {
        this.createAppenderConditionCreator = creator;
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createAppenderConditionCreator must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.createAppenderConditionCreator must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    WriteLock writeLock() {
        WriteLock writeLock = this.readOnly() ? new ReadOnlyWriteLock() : new TableStoreWriteLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L);
        if (writeLock == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.writeLock must not return null");
        }
        if (writeLock == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.writeLock must not return null");
        }
        return writeLock;
    }

    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval == -1 ? 64 : this.deltaCheckpointInterval;
    }

    public QueueOffsetSpec queueOffsetSpec() {
        return this.queueOffsetSpec == null ? QueueOffsetSpec.ofNone() : this.queueOffsetSpec;
    }

    TableStore<SCQMeta> metaStore() {
        return this.metaStore;
    }

    public SingleChronicleQueueBuilder maxTailers(int maxTailers) {
        this.maxTailers = maxTailers;
        return this;
    }

    public int maxTailers() {
        return this.maxTailers;
    }

    @Deprecated
    public SingleChronicleQueueBuilder bufferBytesStoreCreator(ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator) {
        this.bufferBytesStoreCreator = bufferBytesStoreCreator;
        return this;
    }

    @Deprecated
    @Nullable
    public ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator() {
        return this.bufferBytesStoreCreator;
    }

    public SingleChronicleQueueBuilder asyncBufferCreator(AsyncBufferCreator asyncBufferCreator) {
        this.bufferBytesStoreCreator = asyncBufferCreator;
        return this;
    }

    public AsyncBufferCreator asyncBufferCreator() {
        if (this.bufferBytesStoreCreator instanceof AsyncBufferCreator) {
            return (AsyncBufferCreator)this.bufferBytesStoreCreator;
        }
        return null;
    }

    public SingleChronicleQueueBuilder enablePreloader(long pretouchIntervalMillis) {
        this.pretouchIntervalMillis = pretouchIntervalMillis;
        return this;
    }

    public long pretouchIntervalMillis() {
        return this.pretouchIntervalMillis;
    }

    public boolean hasPretouchIntervalMillis() {
        return this.pretouchIntervalMillis != null;
    }

    public SingleChronicleQueueBuilder path(String path) {
        return this.path(new File(path));
    }

    public SingleChronicleQueueBuilder path(File path) {
        this.path = path;
        return this;
    }

    public SingleChronicleQueueBuilder path(Path path) {
        this.path = path.toFile();
        return this;
    }

    public SingleChronicleQueueBuilder onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        if (onRingBufferStats == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'onRingBufferStats') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.onRingBufferStats must not be null");
        }
        if (onRingBufferStats == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'onRingBufferStats') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.onRingBufferStats must not be null");
        }
        this.onRingBufferStats = onRingBufferStats;
        return this;
    }

    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    @NotNull
    public File path() {
        File file = this.path;
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.path must not return null");
        }
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.path must not return null");
        }
        return file;
    }

    public SingleChronicleQueueBuilder blockSize(long blockSize) {
        this.blockSize = Math.max(SMALL_BLOCK_SIZE, blockSize);
        return this;
    }

    public SingleChronicleQueueBuilder blockSize(int blockSize) {
        return this.blockSize((long)blockSize);
    }

    public long blockSize() {
        long bs = this.blockSize == null ? (OS.is64Bit() ? 0x4000000L : SMALL_BLOCK_SIZE) : this.blockSize;
        long minSize = Math.max(SMALL_BLOCK_SIZE, 32L * (long)this.indexCount());
        return Math.max(minSize, bs);
    }

    @Deprecated
    public SingleChronicleQueueBuilder useSparseFiles(boolean useSparseFiles) {
        if (useSparseFiles && OS.isLinux() && OS.is64Bit()) {
            this.useSparseFiles = useSparseFiles;
        }
        if (!useSparseFiles) {
            this.useSparseFiles = useSparseFiles;
        }
        return this;
    }

    @Deprecated
    public SingleChronicleQueueBuilder sparseCapacity(long sparseCapacity) {
        this.sparseCapacity = sparseCapacity;
        return this;
    }

    public long sparseCapacity() {
        long bs = this.sparseCapacity == null ? 0x8000000000L : this.sparseCapacity;
        long minSize = Math.max(SMALL_BLOCK_SIZE, 32L * (long)this.indexCount());
        return Math.max(minSize, bs);
    }

    @Deprecated
    public boolean useSparseFiles() {
        return OS.isLinux() && OS.is64Bit() && this.sparseCapacity != null;
    }

    public SingleChronicleQueueBuilder testBlockSize() {
        return this.blockSize(SMALL_BLOCK_SIZE);
    }

    @NotNull
    public SingleChronicleQueueBuilder wireType(@NotNull WireType wireType) {
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.wireType must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wireType') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.wireType must not be null");
        }
        if (wireType == WireType.DELTA_BINARY) {
            this.deltaCheckpointInterval(64);
        }
        this.wireType = wireType;
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.wireType must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.wireType must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    private void deltaCheckpointInterval(int deltaCheckpointInterval) {
        assert (this.checkIsPowerOf2(deltaCheckpointInterval));
        this.deltaCheckpointInterval = deltaCheckpointInterval;
    }

    private boolean checkIsPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }

    @NotNull
    public WireType wireType() {
        WireType wireType = this.wireType == null ? WireType.BINARY_LIGHT : this.wireType;
        if (wireType == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.wireType must not return null");
        }
        if (wireType == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.wireType must not return null");
        }
        return wireType;
    }

    @NotNull
    public SingleChronicleQueueBuilder rollCycle(@NotNull RollCycle rollCycle) {
        if (rollCycle == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollCycle') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollCycle must not be null");
        }
        if (rollCycle == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'rollCycle') of net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollCycle must not be null");
        }
        assert (rollCycle != null);
        this.rollCycle = RollCycles.warnIfDeprecated(rollCycle);
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollCycle must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollCycle must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public RollCycle rollCycle() {
        RollCycle rollCycle = this.rollCycle == null ? SingleChronicleQueueBuilder.loadDefaultRollCycle() : this.rollCycle;
        if (rollCycle == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollCycle must not return null");
        }
        if (rollCycle == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.rollCycle must not return null");
        }
        return rollCycle;
    }

    public long bufferCapacity() {
        return Math.min(this.blockSize() / 4L, this.bufferCapacity == null ? 0x200000L : this.bufferCapacity);
    }

    @NotNull
    public SingleChronicleQueueBuilder bufferCapacity(long bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.bufferCapacity must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.bufferCapacity must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public SingleChronicleQueueBuilder epoch(long epoch) {
        this.epoch = epoch;
        this.queueOffsetSpec = QueueOffsetSpec.ofEpoch(epoch);
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.epoch must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.epoch must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    public long epoch() {
        return this.epoch == null ? Jvm.getLong((String)"net.openhft.queue.builder.defaultEpoch", (Long)0L) : this.epoch;
    }

    @Deprecated
    @NotNull
    public SingleChronicleQueueBuilder buffered(boolean isBuffered) {
        this.writeBufferMode = isBuffered ? BufferMode.Asynchronous : BufferMode.None;
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.buffered must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.buffered must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public BufferMode writeBufferMode() {
        BufferMode bufferMode = this.wireType() == WireType.DELTA_BINARY ? BufferMode.None : (this.writeBufferMode == null ? BufferMode.None : this.writeBufferMode);
        if (bufferMode == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.writeBufferMode must not return null");
        }
        if (bufferMode == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.writeBufferMode must not return null");
        }
        return bufferMode;
    }

    public SingleChronicleQueueBuilder writeBufferMode(BufferMode writeBufferMode) {
        this.writeBufferMode = writeBufferMode;
        return this;
    }

    public BufferMode readBufferMode() {
        return this.readBufferMode == null ? BufferMode.None : this.readBufferMode;
    }

    public SingleChronicleQueueBuilder readBufferMode(BufferMode readBufferMode) {
        this.readBufferMode = readBufferMode;
        return this;
    }

    @NotNull
    public EventLoop eventLoop() {
        if (this.eventLoop == null) {
            OnDemandEventLoop onDemandEventLoop = new OnDemandEventLoop(() -> new MediumEventLoop(null, this.path.getName(), Pauser.busy(), true, "none"));
            if (onDemandEventLoop == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.eventLoop must not return null");
            }
            if (onDemandEventLoop == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.eventLoop must not return null");
            }
            return onDemandEventLoop;
        }
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.eventLoop must not return null");
        }
        if (eventLoop == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.eventLoop must not return null");
        }
        return eventLoop;
    }

    @NotNull
    public SingleChronicleQueueBuilder eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = this;
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.eventLoop must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/single/SingleChronicleQueueBuilder.eventLoop must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    public boolean enableRingBufferMonitoring() {
        return this.enableRingBufferMonitoring != null && this.enableRingBufferMonitoring != false;
    }

    public SingleChronicleQueueBuilder enableRingBufferMonitoring(boolean enableRingBufferMonitoring) {
        this.enableRingBufferMonitoring = enableRingBufferMonitoring;
        return this;
    }

    public boolean ringBufferReaderCanDrain() {
        return this.ringBufferReaderCanDrain != null && this.ringBufferReaderCanDrain != false;
    }

    public SingleChronicleQueueBuilder ringBufferReaderCanDrain(boolean ringBufferReaderCanDrain) {
        this.ringBufferReaderCanDrain = ringBufferReaderCanDrain;
        return this;
    }

    public boolean ringBufferForceCreateReader() {
        return this.ringBufferForceCreateReader != null && this.ringBufferForceCreateReader != false;
    }

    public SingleChronicleQueueBuilder ringBufferForceCreateReader(boolean ringBufferForceCreateReader) {
        this.ringBufferForceCreateReader = ringBufferForceCreateReader;
        return this;
    }

    public boolean ringBufferReopenReader() {
        return this.ringBufferReopenReader != null && this.ringBufferReopenReader != false;
    }

    public SingleChronicleQueueBuilder ringBufferReopenReader(boolean ringBufferReopenReader) {
        this.ringBufferReopenReader = ringBufferReopenReader;
        return this;
    }

    public HandlerPriority drainerPriority() {
        return this.drainerPriority;
    }

    public SingleChronicleQueueBuilder drainerPriority(HandlerPriority drainerPriority) {
        this.drainerPriority = drainerPriority;
        return this;
    }

    public int drainerTimeoutMS() {
        return this.drainerTimeoutMS <= 0 ? 10000 : this.drainerTimeoutMS;
    }

    public SingleChronicleQueueBuilder drainerTimeoutMS(int timeout) {
        this.drainerTimeoutMS = timeout;
        return this;
    }

    public Supplier<Pauser> ringBufferPauserSupplier() {
        return this.ringBufferPauserSupplier == null ? Pauser::busy : this.ringBufferPauserSupplier;
    }

    public SingleChronicleQueueBuilder ringBufferPauserSupplier(Supplier<Pauser> ringBufferPauserSupplier) {
        this.ringBufferPauserSupplier = ringBufferPauserSupplier;
        return this;
    }

    public SingleChronicleQueueBuilder indexCount(int indexCount) {
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        return this;
    }

    public int indexCount() {
        return this.indexCount == null || this.indexCount <= 0 ? this.rollCycle().defaultIndexCount() : this.indexCount.intValue();
    }

    public SingleChronicleQueueBuilder indexSpacing(int indexSpacing) {
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        return this;
    }

    public int indexSpacing() {
        return this.indexSpacing == null || this.indexSpacing <= 0 ? this.rollCycle().defaultIndexSpacing() : this.indexSpacing.intValue();
    }

    public TimeProvider timeProvider() {
        return this.timeProvider == null ? SystemTimeProvider.INSTANCE : this.timeProvider;
    }

    public SingleChronicleQueueBuilder timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    public Supplier<TimingPauser> pauserSupplier() {
        return this.pauserSupplier == null ? TIMING_PAUSER_SUPPLIER : this.pauserSupplier;
    }

    public SingleChronicleQueueBuilder pauserSupplier(Supplier<TimingPauser> pauser) {
        this.pauserSupplier = pauser;
        return this;
    }

    public SingleChronicleQueueBuilder timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    public long timeoutMS() {
        return this.timeoutMS == null ? 10000L : this.timeoutMS;
    }

    public SingleChronicleQueueBuilder storeFileListener(StoreFileListener storeFileListener) {
        this.storeFileListener = storeFileListener;
        return this;
    }

    public StoreFileListener storeFileListener() {
        return this.storeFileListener == null ? StoreFileListeners.DEBUG : this.storeFileListener;
    }

    public SingleChronicleQueueBuilder sourceId(int sourceId) {
        if (sourceId < 0) {
            throw new IllegalArgumentException("Invalid source Id, must be positive");
        }
        this.sourceId = sourceId;
        return this;
    }

    public int sourceId() {
        return this.sourceId == null ? 0 : this.sourceId;
    }

    public boolean readOnly() {
        return Boolean.TRUE.equals(this.readOnly) && !OS.isWindows();
    }

    public SingleChronicleQueueBuilder readOnly(boolean readOnly) {
        if (OS.isWindows() && readOnly) {
            Jvm.warn().on(SingleChronicleQueueBuilder.class, "Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write.");
        } else {
            this.readOnly = readOnly;
        }
        return this;
    }

    public boolean doubleBuffer() {
        return this.doubleBuffer;
    }

    public SingleChronicleQueueBuilder doubleBuffer(boolean doubleBuffer) {
        this.doubleBuffer = doubleBuffer;
        return this;
    }

    public Supplier<BiConsumer<BytesStore, Bytes<?>>> encodingSupplier() {
        return this.encodingSupplier;
    }

    public Supplier<BiConsumer<BytesStore, Bytes<?>>> decodingSupplier() {
        return this.decodingSupplier;
    }

    public SingleChronicleQueueBuilder codingSuppliers(@Nullable Supplier<BiConsumer<BytesStore, Bytes<?>>> encodingSupplier, @Nullable Supplier<BiConsumer<BytesStore, Bytes<?>>> decodingSupplier) {
        if (encodingSupplier == null != (decodingSupplier == null)) {
            throw new UnsupportedOperationException("Both encodingSupplier and decodingSupplier must be set or neither");
        }
        this.encodingSupplier = encodingSupplier;
        this.decodingSupplier = decodingSupplier;
        return this;
    }

    public SecretKeySpec key() {
        return this.key;
    }

    protected void preBuild() {
        try {
            this.initializeMetadata();
        }
        catch (Exception ex) {
            Closeable.closeQuietly(this.metaStore);
            throw ex;
        }
        if ((this.epoch == null || this.epoch == 0L) && this.rollTime != null && this.rollTimeZone != null) {
            this.rollTime(this.rollTime, this.rollTimeZone);
        }
    }

    public boolean checkInterrupts() {
        if (System.getProperties().contains("chronicle.queue.checkInterrupts")) {
            return Jvm.getBoolean((String)"chronicle.queue.checkInterrupts");
        }
        return this.checkInterrupts;
    }

    public SingleChronicleQueueBuilder checkInterrupts(boolean checkInterrupts) {
        this.checkInterrupts = checkInterrupts;
        return this;
    }

    public long forceDirectoryListingRefreshIntervalMs() {
        return this.forceDirectoryListingRefreshIntervalMs;
    }

    public SingleChronicleQueueBuilder forceDirectoryListingRefreshIntervalMs(long forceDirectoryListingRefreshIntervalMs) {
        this.forceDirectoryListingRefreshIntervalMs = forceDirectoryListingRefreshIntervalMs;
        return this;
    }

    @Deprecated
    public SingleChronicleQueueBuilder clone() {
        try {
            return (SingleChronicleQueueBuilder)super.clone();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public SingleChronicleQueueBuilder setAllNullFields(@Nullable SingleChronicleQueueBuilder parentBuilder) {
        if (parentBuilder == null) {
            return this;
        }
        if (!this.getClass().isAssignableFrom(parentBuilder.getClass()) && !parentBuilder.getClass().isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException("Classes are not in same implementation hierarchy");
        }
        List sourceFieldInfo = Wires.fieldInfos(parentBuilder.getClass());
        for (FieldInfo fieldInfo : Wires.fieldInfos(this.getClass())) {
            if (!sourceFieldInfo.contains(fieldInfo)) continue;
            Object resultV = fieldInfo.get((Object)this);
            Object parentV = fieldInfo.get((Object)parentBuilder);
            if (resultV != null || parentV == null) continue;
            fieldInfo.set((Object)this, parentV);
        }
        return this;
    }

    public WriteLock appendLock() {
        return this.readOnly() ? WriteLock.NO_OP : new TableStoreWriteLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L, "chronicle.append.lock");
    }

    public SingleChronicleQueueBuilder appenderListener(AppenderListener appenderListener) {
        this.appenderListener = appenderListener;
        return this;
    }

    public AppenderListener appenderListener() {
        return this.appenderListener;
    }

    public SingleChronicleQueueBuilder syncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
        return this;
    }

    public SyncMode syncMode() {
        return this.syncMode == null ? MappedFile.DEFAULT_SYNC_MODE : this.syncMode;
    }

    static {
        Constructor<?> co;
        SMALL_BLOCK_SIZE = OS.isWindows() ? 65536L : (long)OS.pageSize();
        storeFactory = SingleChronicleQueueBuilder::createStore;
        TIMING_PAUSER_SUPPLIER = DefaultPauserSupplier.INSTANCE;
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQMeta.class, "SCQMeta");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "SCQSRoll");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class, "SCQSIndexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "SCQStore");
        try {
            co = Class.forName("software.chronicle.enterprise.queue.EnterpriseSingleChronicleQueue").getDeclaredConstructors()[0];
            Jvm.setAccessible(co);
        }
        catch (Exception e) {
            co = null;
        }
        ENTERPRISE_QUEUE_CONSTRUCTOR = co;
    }

    static enum DefaultPauserSupplier implements Supplier<TimingPauser>
    {
        INSTANCE;


        @Override
        public TimingPauser get() {
            return new TimeoutPauser(500000);
        }
    }
}

