/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceCountedCache<K, T extends ReferenceCounted & Closeable, V, E extends Throwable>
extends AbstractCloseable {
    private final Map<K, T> cache = new LinkedHashMap<K, T>();
    private final Function<T, V> transformer;
    private final ThrowingFunction<K, T, E> creator;
    private final ReferenceChangeListener referenceChangeListener;

    public ReferenceCountedCache(Function<T, V> transformer, ThrowingFunction<K, T, E> creator) {
        this.transformer = transformer;
        this.creator = creator;
        this.referenceChangeListener = new TriggerFlushOnLastReferenceRemoval();
        this.singleThreadedCheckDisabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    V get(@NotNull K key) throws E {
        V rv;
        this.throwExceptionIfClosed();
        Map<K, T> map = this.cache;
        synchronized (map) {
            @Nullable ReferenceCounted value = (ReferenceCounted)this.cache.get(key);
            if (value == null) {
                value = (ReferenceCounted)this.creator.apply(key);
                value.reserveTransfer(INIT, (ReferenceOwner)this);
                value.addReferenceChangeListener(this.referenceChangeListener);
                this.cache.put(key, value);
            }
            rv = this.transformer.apply(value);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performClose() {
        ArrayList<ReferenceCounted> retained = new ArrayList<ReferenceCounted>();
        Map<K, T> map = this.cache;
        synchronized (map) {
            for (ReferenceCounted value : this.cache.values()) {
                try {
                    value.release((ReferenceOwner)this);
                    if (value.refCount() <= 0) continue;
                    retained.add(value);
                }
                catch (Exception e) {
                    Jvm.debug().on(((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
            this.cache.clear();
        }
        if (retained.isEmpty() || !Jvm.isResourceTracing()) {
            return;
        }
        boolean interrupted = false;
        try {
            for (int i = 1; i <= 2500; ++i) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (!retained.stream().noneMatch(v -> v.refCount() > 0)) continue;
                (i > 9 ? Jvm.perf() : Jvm.debug()).on(((Object)((Object)this)).getClass(), "Took " + i + " ms to release " + retained);
                return;
            }
            retained.stream().filter(o -> o instanceof ManagedCloseable).map(o -> (ManagedCloseable)o).forEach(ManagedCloseable::warnAndCloseIfNotClosed);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class TriggerFlushOnLastReferenceRemoval
    implements ReferenceChangeListener {
        private final Runnable bgCleanup = this::bgCleanup;

        private TriggerFlushOnLastReferenceRemoval() {
        }

        public void onReferenceRemoved(ReferenceCounted referenceCounted, ReferenceOwner referenceOwner) {
            if (referenceOwner != ReferenceCountedCache.this && referenceCounted.refCount() == 1) {
                BackgroundResourceReleaser.run((Runnable)this.bgCleanup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bgCleanup() {
            Map map = ReferenceCountedCache.this.cache;
            synchronized (map) {
                ReferenceCountedCache.this.cache.entrySet().removeIf(entry -> {
                    ReferenceCounted value = (ReferenceCounted)entry.getValue();
                    int refCount = value.refCount();
                    if (refCount == 1) {
                        value.release((ReferenceOwner)ReferenceCountedCache.this);
                    }
                    return refCount <= 1;
                });
            }
        }
    }
}

