/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.main;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;

public final class InternalPingPongMain {
    static int runtime = Integer.getInteger("runtime", 30);
    static String basePath = System.getProperty("path", OS.TMP);
    static AtomicLong writeTime = new AtomicLong();
    static AtomicInteger writeCount = new AtomicInteger();
    static AtomicInteger readCount = new AtomicInteger();
    static AtomicBoolean running = new AtomicBoolean(true);

    public static void main(String[] args) {
        System.out.println(" -Druntime=" + runtime + " -Dpath=" + basePath);
        MappedFile.warmup();
        InternalPingPongMain.pingPong(64);
    }

    static void pingPong(int size) {
        String path = basePath + "/test-q-" + Time.uniqueId();
        Histogram readDelay = new Histogram();
        Histogram readDelay2 = new Histogram();
        try (ChronicleQueue queue = InternalPingPongMain.createQueue(path);){
            Thread reader = new Thread(() -> {
                ExcerptTailer tailer = queue.createTailer();
                while (running.get()) {
                    while (readCount.get() == writeCount.get()) {
                    }
                    long wakeTime = System.nanoTime();
                    while (running.get()) {
                        DocumentContext dc = tailer.readingDocument(true);
                        Throwable throwable = null;
                        try {
                            if (dc.isPresent()) break;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (dc == null) continue;
                            if (throwable != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            dc.close();
                        }
                    }
                    long delay = wakeTime - writeTime.get();
                    long time = System.nanoTime() - wakeTime;
                    readDelay2.sample((double)time);
                    readDelay.sample((double)delay);
                    if (time + delay > 20000L) {
                        System.out.println("td " + delay + " + " + time);
                    }
                    if (readCount.get() == 100000) {
                        System.out.println("reset");
                        readDelay.reset();
                        readDelay2.reset();
                    }
                    readCount.incrementAndGet();
                }
            });
            reader.setDaemon(true);
            reader.start();
            Jvm.pause((long)100L);
            long finish = System.currentTimeMillis() + (long)runtime * 1000L;
            ExcerptAppender appender = queue.acquireAppender();
            while (System.currentTimeMillis() < finish) {
                if (readCount.get() < writeCount.get()) {
                    Thread.yield();
                    continue;
                }
                try (DocumentContext dc = appender.writingDocument(false);){
                    dc.wire().bytes().writeSkip((long)size);
                }
                writeCount.incrementAndGet();
                writeTime.set(System.nanoTime());
            }
            running.set(false);
        }
        System.out.println("read delay: " + readDelay.toMicrosFormat());
        System.out.println("read delay2: " + readDelay2.toMicrosFormat());
        IOTools.deleteDirWithFiles((String)path, (int)2);
    }

    @NotNull
    private static ChronicleQueue createQueue(String path) {
        return ChronicleQueue.single(path);
    }

    static {
        System.setProperty("jvm.safepoint.enabled", "true");
    }
}

