/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;

public final class MessageToTextQueueEntryHandler
implements QueueEntryHandler {
    private final Bytes textConversionTarget = Bytes.elasticByteBuffer();
    private final WireType wireType;

    public MessageToTextQueueEntryHandler(WireType wireType) {
        this.wireType = wireType;
    }

    private static boolean isBinaryFormat(byte dataFormatIndicator) {
        return dataFormatIndicator < 0;
    }

    @Override
    public void accept(WireIn wireIn, Consumer<String> messageHandler) {
        String text;
        Bytes serialisedMessage = wireIn.bytes();
        byte dataFormatIndicator = serialisedMessage.readByte(serialisedMessage.readPosition());
        if (MessageToTextQueueEntryHandler.isBinaryFormat(dataFormatIndicator)) {
            this.textConversionTarget.clear();
            BinaryWire binaryWire = new BinaryWire(serialisedMessage);
            binaryWire.copyTo((WireOut)this.wireType.apply((Object)this.textConversionTarget));
            text = this.textConversionTarget.toString();
        } else {
            text = serialisedMessage.toString();
        }
        messageHandler.accept(text);
    }

    @Override
    public void close() {
        this.textConversionTarget.releaseLast();
    }
}

