/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.TimingPauser;

public class TableStoreWriteLock
extends AbstractTSQueueLock
implements WriteLock {
    private static final String LOCK_KEY = "chronicle.write.lock";
    private static final long PID = Jvm.getProcessId();
    private final long timeout;
    private Thread lockedByThread = null;

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs) {
        super(LOCK_KEY, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        this.throwExceptionIfClosed();
        assert (this.checkNotAlreadyLocked());
        try {
            int i = 0;
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (i++ > 1000 && Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted for the lock file:" + this.path);
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
            }
            assert ((this.lockedByThread = Thread.currentThread()) != null);
        }
        catch (TimeoutException e) {
            long lockedByPID = this.lock.getVolatileValue(Long.MIN_VALUE);
            String lockedBy = lockedByPID == Long.MIN_VALUE ? "unknown" : (lockedByPID == PID ? "me" : Long.toString(lockedByPID));
            Jvm.warn().on(this.getClass(), "Couldn't acquire write lock after " + this.timeout + "ms for the lock file:" + this.path + ", overriding the lock. Lock was held by " + lockedBy);
            this.forceUnlock();
            this.pauser.reset();
            this.lock();
        }
        finally {
            this.pauser.reset();
        }
    }

    private boolean checkNotAlreadyLocked() {
        if (this.lockedByThread == null) {
            return true;
        }
        if (this.lockedByThread == Thread.currentThread()) {
            throw new AssertionError((Object)"Lock is already acquired by current thread and is not reentrant - nested document context?");
        }
        return true;
    }

    @Override
    public void unlock() {
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Write lock was unlocked by someone else! For the lock file:" + this.path);
        }
        if (!$assertionsDisabled) {
            this.lockedByThread = null;
            if (null != null) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean locked() {
        return this.lock.getVolatileValue(Long.MIN_VALUE) != Long.MIN_VALUE;
    }
}

