/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.queue.RollDetails;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireStorePool
extends AbstractCloseable {
    private static final int ROLL_CYCLE_CACHE_SIZE = 64;
    private static final int INDEX_MASK = 63;
    @NotNull
    private final WireStoreSupplier supplier;
    @NotNull
    private final Map<RollDetails, WeakReference<SingleChronicleQueueStore>> stores;
    private final StoreFileListener storeFileListener;
    private final RollDetails[] cache = new RollDetails[64];

    private WireStorePool(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        this.supplier = supplier;
        this.storeFileListener = storeFileListener;
        this.stores = new ConcurrentHashMap<RollDetails, WeakReference<SingleChronicleQueueStore>>();
    }

    @NotNull
    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        return new WireStorePool(supplier, storeFileListener);
    }

    private static int cacheIndex(int cycle) {
        return cycle & 0x3F;
    }

    protected boolean performCloseInBackground() {
        return true;
    }

    protected void performClose() {
        this.stores.values().stream().map(Reference::get).filter(Objects::nonNull).forEach(s -> this.release((SingleChronicleQueueStore)s, true));
    }

    @Nullable
    public synchronized SingleChronicleQueueStore acquire(int cycle, long epoch, boolean createIfAbsent) {
        SingleChronicleQueueStore store;
        WeakReference<SingleChronicleQueueStore> reference;
        this.throwExceptionIfClosed();
        int cacheIndex = WireStorePool.cacheIndex(cycle);
        RollDetails rollDetails = this.cache[cacheIndex];
        if (rollDetails == null || rollDetails.cycle() != cycle) {
            this.cache[cacheIndex] = rollDetails = new RollDetails(cycle, epoch);
        }
        if ((reference = this.stores.get((Object)rollDetails)) != null && (store = (SingleChronicleQueueStore)reference.get()) != null) {
            if (store.tryReserve()) {
                return store;
            }
            Jvm.warn().on(((Object)((Object)this)).getClass(), "Logic failure - should never happen " + store);
            this.stores.remove((Object)rollDetails);
        }
        if ((store = this.supplier.acquire(cycle, createIfAbsent)) != null) {
            this.stores.put(rollDetails, new WeakReference<SingleChronicleQueueStore>(store));
            this.storeFileListener.onAcquired(cycle, store.file());
        }
        return store;
    }

    public int nextCycle(int currentCycle, @NotNull TailerDirection direction) throws ParseException {
        return this.supplier.nextCycle(currentCycle, direction);
    }

    public synchronized void release(@NotNull SingleChronicleQueueStore store, boolean closeQueue) {
        if (closeQueue) {
            while (store.refCount() > 1L) {
                store.release();
            }
            store.close();
        } else if (store.refCount() > 1L) {
            store.release();
        } else {
            store.close();
        }
        long refCount = store.refCount();
        assert (refCount >= 0L);
        if (refCount == 0L) {
            for (Map.Entry<RollDetails, WeakReference<SingleChronicleQueueStore>> entry : this.stores.entrySet()) {
                WeakReference<SingleChronicleQueueStore> ref = entry.getValue();
                if (ref == null || ref.get() != store) continue;
                this.stores.remove((Object)entry.getKey());
                this.storeFileListener.onReleased(entry.getKey().cycle(), store.file());
                store.close();
                return;
            }
            if (Jvm.isDebugEnabled(((Object)((Object)this)).getClass())) {
                Jvm.debug().on(((Object)((Object)this)).getClass(), "Store was not registered: " + store.file());
            }
        }
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        return this.supplier.cycles(lowerCycle, upperCycle);
    }

    public boolean isEmpty() {
        return this.stores.isEmpty();
    }
}

