/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.CycleCalculator;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChronicleQueueBuilder<B extends ChronicleQueueBuilder, Q extends ChronicleQueue>
extends Cloneable,
Marshallable {
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> single() {
        SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> builder = SingleChronicleQueueBuilder.builder();
        builder.wireType(WireType.BINARY_LIGHT);
        return builder;
    }

    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> single(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> single(@NotNull File basePath) {
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    @Deprecated
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> singleText(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.text(new File(basePath));
    }

    @NotNull
    public Q build();

    @NotNull
    public B onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> var1);

    @NotNull
    public Consumer<BytesRingBufferStats> onRingBufferStats();

    @NotNull
    public File path();

    @NotNull
    public B blockSize(int var1);

    public B blockSize(long var1);

    @NotNull
    default public B testBlockSize() {
        return this.blockSize(65536);
    }

    public long blockSize();

    @NotNull
    public B wireType(@NotNull WireType var1);

    @NotNull
    public WireType wireType();

    @NotNull
    public B rollCycle(@NotNull RollCycle var1);

    @Deprecated
    @NotNull
    public B epoch(long var1);

    public long epoch();

    public B rollTime(@NotNull LocalTime var1, ZoneId var2);

    @NotNull
    public RollCycle rollCycle();

    @Deprecated
    @NotNull
    public B buffered(boolean var1);

    @Deprecated
    public boolean buffered();

    @NotNull
    public B bufferCapacity(long var1);

    public long bufferCapacity();

    public B writeBufferMode(BufferMode var1);

    @NotNull
    public BufferMode writeBufferMode();

    public B readBufferMode(BufferMode var1);

    public BufferMode readBufferMode();

    @NotNull
    public B eventLoop(EventLoop var1);

    @Nullable
    public EventLoop eventLoop();

    public B indexCount(int var1);

    public int indexCount();

    public B indexSpacing(int var1);

    public int indexSpacing();

    public WireStoreFactory storeFactory();

    public B storeFileListener(StoreFileListener var1);

    public StoreFileListener storeFileListener();

    public boolean hasPretouchIntervalMillis();

    public boolean readOnly();

    public B readOnly(boolean var1);

    public CycleCalculator cycleCalculator();

    public B strongAppenders(boolean var1);

    public boolean strongAppenders();

    public Object clone();

    public B pauserSupplier(Supplier<TimingPauser> var1);

    default public B path(String path) {
        return this.path(new File(path));
    }

    public B path(File var1);

    default public B setAllNullFields(@Nullable ChronicleQueueBuilder parentBuilder) {
        if (parentBuilder == null) {
            return (B)this;
        }
        if (!this.getClass().isAssignableFrom(parentBuilder.getClass()) && !parentBuilder.getClass().isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException("Classes are not in same implementation hierarchy");
        }
        List sourceFieldInfo = Wires.fieldInfos(parentBuilder.getClass());
        for (FieldInfo fieldInfo : Wires.fieldInfos(this.getClass())) {
            if (!sourceFieldInfo.contains(fieldInfo)) continue;
            Object resultV = fieldInfo.get((Object)this);
            Object parentV = fieldInfo.get((Object)parentBuilder);
            if (resultV != null || parentV == null) continue;
            fieldInfo.set((Object)this, parentV);
        }
        return (B)this;
    }

    public boolean hasBlockSize();
}

