/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.ThrowingBiFunction;
import net.openhft.chronicle.core.util.Updater;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.QueueOffsetSpec;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.NoopQueueLock;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.single.ReadOnlyWriteLock;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQMeta;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TSQueueLock;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.ReadonlyTableStore;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueBuilder<S extends SingleChronicleQueueBuilder, Q extends SingleChronicleQueue>
extends AbstractChronicleQueueBuilder<SingleChronicleQueueBuilder<S, Q>, Q> {
    private static final Logger LOGGER;
    private static final String ENTERPRISE_ONLY = "this is only supported in the enterprise version";
    private WireStoreFactory storeFactory;
    private static final Constructor<SingleChronicleQueue> ENTERPISE_QUEUE_CONSTRUCTOR;
    private static final Constructor<SingleChronicleQueueBuilder> ENTERPRISE_QUEUE_BUILDER_CONSTRUCTOR;
    public static final boolean IS_ENTERPRISE_QUEUE_ON_CLASSPATH;
    protected TableStore<SCQMeta> metaStore;

    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> builder() {
        try {
            return ENTERPRISE_QUEUE_BUILDER_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return new SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue>();
        }
    }

    protected SingleChronicleQueueBuilder() {
    }

    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull String path) {
        this(new File(path));
    }

    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull File path) {
        super(path);
    }

    @Override
    public WireStoreFactory storeFactory() {
        return this.storeFactory == null ? SingleChronicleQueueBuilder::createStore : this.storeFactory;
    }

    public static void addAliases() {
    }

    public static void init() {
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> builder(@NotNull Path path, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder(path.toFile(), wireType);
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        ChronicleQueueBuilder result = SingleChronicleQueueBuilder.builder().wireType(wireType);
        if (file.isFile()) {
            if (!file.getName().endsWith(".cq4")) {
                throw new IllegalArgumentException("Invalid file type: " + file.getName());
            }
            LOGGER.warn("Queues should be configured with the queue directory, not a specific filename. Actual file used: {}", (Object)file.getParentFile());
            ((AbstractChronicleQueueBuilder)result).path(file.getParentFile());
        } else {
            ((AbstractChronicleQueueBuilder)result).path(file);
        }
        return result;
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> binary(@NotNull Path path) {
        return SingleChronicleQueueBuilder.binary(path.toFile());
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> binary(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(new File(basePath));
    }

    @Override
    public boolean hasPretouchIntervalMillis() {
        return false;
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> binary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.BINARY_LIGHT);
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> fieldlessBinary(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.FIELDLESS_BINARY);
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> defaultZeroBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DEFAULT_ZERO_BINARY);
    }

    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> deltaBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DELTA_BINARY);
    }

    @Deprecated
    @NotNull
    public static SingleChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> text(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.TEXT);
    }

    @NotNull
    static SingleChronicleQueueStore createStore(@NotNull RollingChronicleQueue queue, @NotNull Wire wire) {
        SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(queue.rollCycle(), queue.wireType(), (MappedBytes)wire.bytes(), queue.indexCount(), queue.indexSpacing());
        wire.writeEventName((WireKey)MetaDataKeys.header).typedMarshallable((WriteMarshallable)wireStore);
        return wireStore;
    }

    @Nullable
    static SingleChronicleQueueStore loadStore(@NotNull Wire wire) {
        StringBuilder eventName = new StringBuilder();
        wire.readEventName(eventName);
        if (eventName.toString().equals(MetaDataKeys.header.name())) {
            SingleChronicleQueueStore store = (SingleChronicleQueueStore)wire.read().typedMarshallable();
            if (store == null) {
                throw new IllegalArgumentException("Unable to load wire store");
            }
            return store;
        }
        LOGGER.warn("Unable to load store file from input. Queue file may be corrupted.");
        return null;
    }

    private static boolean isQueueReplicationAvailable() {
        try {
            Class.forName("software.chronicle.enterprise.queue.QueueSyncReplicationHandler");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public Q build() {
        if (this.readBufferMode() != BufferMode.None) {
            this.onlyAvailableInEnterprise("Buffering");
        }
        if (this.writeBufferMode() != BufferMode.None) {
            this.onlyAvailableInEnterprise("Buffering");
        }
        super.preBuild();
        Q result = this.buildEnterprise();
        if (result != null) {
            return result;
        }
        return (Q)new SingleChronicleQueue(this);
    }

    private void onlyAvailableInEnterprise(String feature) {
        this.getLogger().warn(feature + " is only supported in Chronicle Queue Enterprise. If you would like to use this feature, please contact sales@chronicle.software for more information.");
    }

    private Q buildEnterprise() {
        if (IS_ENTERPRISE_QUEUE_ON_CLASSPATH) {
            return null;
        }
        try {
            return (Q)ENTERPISE_QUEUE_CONSTRUCTOR.newInstance(this, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier() {
        return null;
    }

    @Nullable
    public Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier() {
        return null;
    }

    @NotNull
    public SingleChronicleQueueBuilder aesEncryption(@Nullable byte[] keyBytes) {
        if (keyBytes == null) {
            this.codingSuppliers(null, null);
            return this;
        }
        this.onlyAvailableInEnterprise("AES encryption");
        return this;
    }

    @NotNull
    public SingleChronicleQueueBuilder codingSuppliers(@Nullable Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier, @Nullable Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier) {
        if (encodingSupplier != null || decodingSupplier != null) {
            this.onlyAvailableInEnterprise("Custom encoding");
        }
        return this;
    }

    @Override
    @NotNull
    public S testBlockSize() {
        super.testBlockSize();
        return (S)this;
    }

    @Override
    public S sourceId(int sourceId) {
        return (S)((SingleChronicleQueueBuilder)super.sourceId(sourceId));
    }

    @Override
    @NotNull
    public S blockSize(int blockSize) {
        return (S)((SingleChronicleQueueBuilder)super.blockSize(blockSize));
    }

    @Override
    @NotNull
    public S blockSize(long blockSize) {
        return (S)((SingleChronicleQueueBuilder)super.blockSize(blockSize));
    }

    @Override
    @NotNull
    public S wireType(@NotNull WireType wireType) {
        return (S)((SingleChronicleQueueBuilder)super.wireType(wireType));
    }

    @Override
    @NotNull
    public S rollCycle(@NotNull RollCycle rollCycle) {
        return (S)((SingleChronicleQueueBuilder)super.rollCycle(rollCycle));
    }

    @Override
    @NotNull
    public S bufferCapacity(long bufferCapacity) {
        return (S)((SingleChronicleQueueBuilder)super.bufferCapacity(bufferCapacity));
    }

    @Override
    @NotNull
    public S epoch(long epoch) {
        return (S)((SingleChronicleQueueBuilder)super.epoch(epoch));
    }

    @Override
    @NotNull
    public S buffered(boolean isBuffered) {
        return (S)((SingleChronicleQueueBuilder)super.buffered(isBuffered));
    }

    @Override
    public S writeBufferMode(BufferMode writeBufferMode) {
        return (S)((SingleChronicleQueueBuilder)super.writeBufferMode(writeBufferMode));
    }

    @Override
    public S readBufferMode(BufferMode readBufferMode) {
        return (S)((SingleChronicleQueueBuilder)super.readBufferMode(readBufferMode));
    }

    @Override
    @NotNull
    public S eventLoop(EventLoop eventLoop) {
        return (S)((SingleChronicleQueueBuilder)super.eventLoop(eventLoop));
    }

    @Override
    public S indexCount(int indexCount) {
        return (S)((SingleChronicleQueueBuilder)super.indexCount(indexCount));
    }

    @Override
    public S indexSpacing(int indexSpacing) {
        return (S)((SingleChronicleQueueBuilder)super.indexSpacing(indexSpacing));
    }

    @Override
    public S timeProvider(TimeProvider timeProvider) {
        return (S)((SingleChronicleQueueBuilder)super.timeProvider(timeProvider));
    }

    @Override
    public S pauserSupplier(Supplier<TimingPauser> pauser) {
        return (S)((SingleChronicleQueueBuilder)super.pauserSupplier(pauser));
    }

    @Override
    public S path(String path) {
        return (S)((SingleChronicleQueueBuilder)super.path(path));
    }

    @Override
    public S timeoutMS(long timeoutMS) {
        return (S)((SingleChronicleQueueBuilder)super.timeoutMS(timeoutMS));
    }

    @Override
    public S readOnly(boolean readOnly) {
        return (S)((SingleChronicleQueueBuilder)super.readOnly(readOnly));
    }

    @Override
    public S storeFileListener(StoreFileListener storeFileListener) {
        return (S)((SingleChronicleQueueBuilder)super.storeFileListener(storeFileListener));
    }

    @Override
    public S recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        return (S)((SingleChronicleQueueBuilder)super.recoverySupplier(recoverySupplier));
    }

    @Override
    public S rollTime(@NotNull LocalTime time, ZoneId zoneId) {
        if (!zoneId.equals(ZoneId.of("UTC"))) {
            this.onlyAvailableInEnterprise("Non-UTC time-zone");
        }
        return (S)((SingleChronicleQueueBuilder)super.rollTime(time, ZoneId.of("UTC")));
    }

    @Override
    protected void initializeMetadata() {
        File metapath = this.metapath();
        this.validateRollCycle(metapath);
        SCQMeta metadata = new SCQMeta(new SCQRoll(this.rollCycle(), this.epoch()), this.deltaCheckpointInterval(), this.sourceId());
        try {
            boolean readOnly = this.readOnly();
            this.metaStore = SingleTableBuilder.binary(metapath, metadata).timeoutMS(this.timeoutMS()).readOnly(readOnly).validateMetadata(!readOnly).build();
            SCQMeta newMeta = this.metaStore.metadata();
            if (this.sourceId() == 0) {
                this.sourceId(newMeta.sourceId());
            }
            if (readOnly && !newMeta.roll().format().equals(this.rollCycle().format())) {
                this.overrideRollCycleForFileNameLength(newMeta.roll().format().length());
            }
        }
        catch (IORuntimeException ex) {
            if (OS.isWindows()) {
                throw ex;
            }
            this.metaStore = new ReadonlyTableStore<SCQMeta>(metadata);
        }
    }

    private void validateRollCycle(File metapath) {
        String[] list;
        if (!metapath.exists() && (list = this.path.list((d, name) -> name.endsWith(".cq4"))) != null && list.length > 0) {
            String filename = list[0];
            if (this.rollCycle().format().length() + 4 != filename.length()) {
                this.overrideRollCycleForFileNameLength(filename.length() - 4);
            }
        }
    }

    private void overrideRollCycleForFileNameLength(int patternLength) {
        for (RollCycles cycle : RollCycles.values()) {
            if (cycle.format().length() != patternLength) continue;
            LOGGER.warn("Overriding roll cycle to " + cycle);
            this.rollCycle = cycle;
            break;
        }
    }

    private File metapath() {
        File storeFilePath;
        if ("".equals(this.path.getPath())) {
            storeFilePath = new File("metadata.cq4t");
        } else {
            storeFilePath = new File(this.path, "metadata.cq4t");
            this.path.mkdirs();
        }
        return storeFilePath;
    }

    @NotNull
    QueueLock queueLock() {
        return SingleChronicleQueueBuilder.isQueueReplicationAvailable() && !this.readOnly() ? new TSQueueLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L) : new NoopQueueLock();
    }

    @NotNull
    WriteLock writeLock() {
        return this.readOnly() ? new ReadOnlyWriteLock() : new TableStoreWriteLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L);
    }

    protected int deltaCheckpointInterval() {
        return -1;
    }

    public S enablePreloader(long pretouchIntervalMillis) {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public QueueOffsetSpec queueOffsetSpec() {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    TableStore<SCQMeta> metaStore() {
        return this.metaStore;
    }

    public Updater<Bytes> messageInitializer() {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public Consumer<Bytes> messageHeaderReader() {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public S messageHeader(Updater<Bytes> messageInitializer, Consumer<Bytes> messageHeaderReader) {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public S maxTailers(int maxTailers) {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public int maxTailers() {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public S bufferBytesStoreCreator(ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator) {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator() {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    public long pretouchIntervalMillis() {
        throw new UnsupportedOperationException(ENTERPRISE_ONLY);
    }

    static {
        Constructor<?> co;
        LOGGER = LoggerFactory.getLogger(SingleChronicleQueueBuilder.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQMeta.class, "SCQMeta");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "SCQSRoll");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class, "SCQSIndexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "SCQStore");
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{TimedStoreRecovery.class});
        try {
            co = Class.forName("software.chronicle.enterprise.queue.EnterpriseSingleChronicleQueue").getDeclaredConstructors()[0];
            co.setAccessible(true);
        }
        catch (Exception e) {
            co = null;
        }
        ENTERPISE_QUEUE_CONSTRUCTOR = co;
        IS_ENTERPRISE_QUEUE_ON_CLASSPATH = co != null;
        try {
            Class<?> aClass = Class.forName("software.chronicle.enterprise.queue.EnterpriseChronicleQueueBuilder");
            co = aClass.getDeclaredConstructor(new Class[0]);
            co.setAccessible(true);
            ClassAliasPool.CLASS_ALIASES.addAlias(aClass, "QueueBuilder");
        }
        catch (Exception e) {
            co = null;
            ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueBuilder.class, "QueueBuilder");
        }
        ENTERPRISE_QUEUE_BUILDER_CONSTRUCTOR = co;
    }
}

