/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChronicleQueueBuilder<B extends ChronicleQueueBuilder<B, Q>, Q extends ChronicleQueue>
implements ChronicleQueueBuilder<B, Q> {
    protected final File path;
    protected long blockSize;
    @NotNull
    protected WireType wireType;
    @NotNull
    protected RollCycle rollCycle;
    protected long epoch;
    protected boolean isBuffered;
    @Nullable
    protected EventLoop eventLoop;
    private long bufferCapacity;
    private int indexSpacing;
    private int indexCount;
    private Consumer<BytesRingBufferStats> onRingBufferStats = NoBytesRingBufferStats.NONE;
    private TimeProvider timeProvider = SystemTimeProvider.INSTANCE;
    private Supplier<Pauser> pauserSupplier = () -> new TimeoutPauser(500000);
    private long timeoutMS = 10000L;
    private WireStoreFactory storeFactory;
    private int sourceId = 0;
    private StoreRecoveryFactory recoverySupplier = TimedStoreRecovery.FACTORY;
    private StoreFileListener storeFileListener = (cycle, file) -> Jvm.debug().on(this.getClass(), "File released " + file);
    private boolean readOnly = false;

    public AbstractChronicleQueueBuilder(File path) {
        this.rollCycle = RollCycles.DAILY;
        this.blockSize = OS.is64Bit() ? 0x4000000L : 262144L;
        this.path = path;
        this.wireType = WireType.BINARY_LIGHT;
        this.epoch = 0L;
        this.bufferCapacity = 0x200000L;
        this.indexSpacing = -1;
        this.indexCount = -1;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }

    @Override
    @NotNull
    public B onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        this.onRingBufferStats = onRingBufferStats;
        return (B)this;
    }

    @Override
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    @Override
    @NotNull
    public File path() {
        return this.path;
    }

    @Override
    @NotNull
    public B blockSize(int blockSize) {
        this.blockSize = Math.max(262144, blockSize);
        return (B)this;
    }

    @Override
    public long blockSize() {
        long minSize = Math.max(262144L, 32L * (long)this.indexCount());
        return Math.max(minSize, this.blockSize);
    }

    @Override
    @NotNull
    public B wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        return (B)this;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public B rollCycle(@NotNull RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return (B)this;
    }

    @Override
    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    @Override
    @NotNull
    public B bufferCapacity(long ringBufferSize) {
        this.bufferCapacity = ringBufferSize;
        return (B)this;
    }

    @Override
    @NotNull
    public B epoch(long epoch) {
        this.epoch = epoch;
        return (B)this;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @Override
    @NotNull
    public B buffered(boolean isBuffered) {
        this.isBuffered = isBuffered;
        return (B)this;
    }

    @Override
    public boolean buffered() {
        return this.isBuffered;
    }

    @Override
    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    @NotNull
    public B eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return (B)this;
    }

    @Override
    @NotNull
    public B bufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        this.isBuffered = true;
        return (B)this;
    }

    @Override
    public B indexCount(int indexCount) {
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        return (B)this;
    }

    @Override
    public int indexCount() {
        return this.indexCount <= 0 ? this.rollCycle.defaultIndexCount() : this.indexCount;
    }

    @Override
    public B indexSpacing(int indexSpacing) {
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        return (B)this;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing <= 0 ? this.rollCycle.defaultIndexSpacing() : this.indexSpacing;
    }

    public TimeProvider timeProvider() {
        return this.timeProvider;
    }

    public B timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return (B)this;
    }

    public Supplier<Pauser> pauserSupplier() {
        return this.pauserSupplier;
    }

    public B pauserSupplier(Supplier<Pauser> pauser) {
        this.pauserSupplier = pauser;
        return (B)this;
    }

    public B timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return (B)this;
    }

    public long timeoutMS() {
        return this.timeoutMS;
    }

    public void storeFactory(WireStoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    @Override
    public WireStoreFactory storeFactory() {
        return this.storeFactory;
    }

    @Override
    public B storeFileListener(StoreFileListener storeFileListener) {
        this.storeFileListener = storeFileListener;
        return (B)this;
    }

    @Override
    public StoreFileListener storeFileListener() {
        return this.storeFileListener;
    }

    public B sourceId(int sourceId) {
        if (sourceId < 0) {
            throw new IllegalArgumentException("Invalid source Id, must be positive");
        }
        this.sourceId = sourceId;
        return (B)this;
    }

    public int sourceId() {
        return this.sourceId;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public B recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        this.recoverySupplier = recoverySupplier;
        return (B)this;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public B readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (B)this;
    }

    static enum NoBytesRingBufferStats implements Consumer<BytesRingBufferStats>
    {
        NONE;


        @Override
        public void accept(BytesRingBufferStats bytesRingBufferStats) {
        }
    }
}

