/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.queue.ExcerptHistory;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class VanillaExcerptHistory
extends AbstractMarshallable
implements ExcerptHistory {
    public static final int MESSAGE_HISTORY_LENGTH = 20;
    private static final ThreadLocal<ExcerptHistory> THREAD_LOCAL = ThreadLocal.withInitial(VanillaExcerptHistory::new);
    private int sources;
    private byte[] sourceIdArray = new byte[20];
    private long[] sourceIndexArray = new long[20];
    private int timings;
    private long[] timingsArray = new long[40];

    static ExcerptHistory getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    static void setThreadLocal(ExcerptHistory md) {
        THREAD_LOCAL.set(md);
    }

    @Override
    public void reset() {
        this.timings = 0;
        this.sources = 0;
    }

    @Override
    public int timings() {
        return this.timings;
    }

    @Override
    public long timing(int n) {
        return this.timingsArray[n];
    }

    @Override
    public int sources() {
        return this.sources;
    }

    @Override
    public int sourceId(int n) {
        return this.sourceIdArray[n] & 0xFF;
    }

    @Override
    public long sourceIndex(int n) {
        return this.sourceIndexArray[n];
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        wire.read(() -> "sources").sequence((Object)this, (t, in) -> {
            t.sources = 0;
            while (in.hasNextSequenceItem()) {
                t.addSource(in.int8(), in.int64());
            }
        });
        wire.read(() -> "timings").sequence((Object)this, (t, in) -> {
            t.timings = 0;
            while (in.hasNextSequenceItem()) {
                t.addTiming(in.int64());
            }
        });
        Object o = wire.parent();
        if (o instanceof DocumentContext) {
            DocumentContext dc = (DocumentContext)o;
            this.addSource(dc.sourceId(), dc.index());
        }
        this.addTiming(System.nanoTime());
    }

    private void addSource(int id, long index) {
        this.sourceIdArray[this.sources] = (byte)id;
        this.sourceIndexArray[this.sources++] = index;
    }

    public void addTiming(long l) {
        this.timingsArray[this.timings++] = l;
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((CharSequence)"sources").sequence((Object)this, (t, out) -> {
            for (int i = 0; i < t.sources; ++i) {
                out.uint8((int)t.sourceIdArray[i]);
                out.int64_0x(t.sourceIndexArray[i]);
            }
        });
        wire.write((CharSequence)"timings").sequence((Object)this, (t, out) -> {
            for (int i = 0; i < t.timings; ++i) {
                out.int64(t.timingsArray[i]);
            }
            out.int64(System.nanoTime());
        });
    }
}

