/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class SingleChronicleQueueBuilder
implements ChronicleQueueBuilder {
    private File path;
    private long blockSize;
    private WireType wireType;
    private RollCycle rollCycle;
    private int headerWaitLoops;
    private int headerWaitDelay;
    private int appendWaitLoops;
    private int appendWaitDelay;

    public SingleChronicleQueueBuilder(String path) {
        this(new File(path));
    }

    public SingleChronicleQueueBuilder(File path) {
        this.path = path;
        this.blockSize = 0x4000000L;
        this.wireType = WireType.BINARY;
        this.headerWaitLoops = 1000;
        this.headerWaitDelay = 10;
        this.appendWaitLoops = 1000;
        this.appendWaitDelay = 0;
        this.rollCycle = RollCycles.DAYS;
    }

    public File path() {
        return this.path;
    }

    public SingleChronicleQueueBuilder blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public SingleChronicleQueueBuilder wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public SingleChronicleQueueBuilder headerWaitLoops(int headerWaitLoops) {
        this.headerWaitLoops = headerWaitLoops;
        return this;
    }

    public int headerWaitLoops() {
        return this.headerWaitLoops;
    }

    public SingleChronicleQueueBuilder headerWaitDelay(int headerWaitDelay) {
        this.headerWaitDelay = headerWaitDelay;
        return this;
    }

    public int headerWaitDelay() {
        return this.headerWaitDelay;
    }

    public SingleChronicleQueueBuilder appendWaitLoops(int appendWaitLoops) {
        this.appendWaitLoops = appendWaitLoops;
        return this;
    }

    public int appendWaitLoops() {
        return this.appendWaitLoops;
    }

    public SingleChronicleQueueBuilder appendWaitDelay(int appendWaitDelay) {
        this.appendWaitDelay = appendWaitDelay;
        return this;
    }

    public int appendWaitDelay() {
        return this.appendWaitDelay;
    }

    public SingleChronicleQueueBuilder rollCycle(RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return this;
    }

    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @Override
    @NotNull
    public ChronicleQueue build() throws IOException {
        return new SingleChronicleQueue(this.clone());
    }

    @NotNull
    public SingleChronicleQueueBuilder clone() {
        try {
            return (SingleChronicleQueueBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SingleChronicleQueueBuilder binary(File name) {
        return SingleChronicleQueueBuilder.binary(name.getAbsolutePath());
    }

    public static SingleChronicleQueueBuilder binary(String name) {
        return new SingleChronicleQueueBuilder(name).wireType(WireType.BINARY);
    }

    public static SingleChronicleQueueBuilder text(File name) {
        return SingleChronicleQueueBuilder.text(name.getAbsolutePath());
    }

    public static SingleChronicleQueueBuilder text(String name) {
        return new SingleChronicleQueueBuilder(name).wireType(WireType.TEXT);
    }

    public static SingleChronicleQueueBuilder raw(File name) {
        return SingleChronicleQueueBuilder.raw(name.getAbsolutePath());
    }

    public static SingleChronicleQueueBuilder raw(String name) {
        return new SingleChronicleQueueBuilder(name).wireType(WireType.RAW);
    }
}

