/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.time.LocalTime;
import java.time.ZoneId;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SCQRoll
implements Demarshallable,
WriteMarshallable {
    private int length;
    @Nullable
    private String format;
    @Nullable
    private LocalTime rollTime;
    @Nullable
    private ZoneId rollTimeZone;
    private long epoch;

    @UsedViaReflection
    private SCQRoll(@NotNull WireIn wire) {
        String zoneId;
        this.length = wire.read((WireKey)RollFields.length).int32();
        this.format = wire.read((WireKey)RollFields.format).text();
        this.epoch = wire.read((WireKey)RollFields.epoch).int64();
        ValueIn rollTimeVIN = wire.read((WireKey)RollFields.rollTime);
        if (rollTimeVIN.hasNext()) {
            this.rollTime = rollTimeVIN.time();
        }
        this.rollTimeZone = (zoneId = wire.read((WireKey)RollFields.rollTimeZone).text()) != null ? ZoneId.of(zoneId) : null;
    }

    SCQRoll(@NotNull RollCycle rollCycle, long epoch, @Nullable LocalTime rollTime, @Nullable ZoneId rollTimeZone) {
        this.length = rollCycle.lengthInMillis();
        this.format = rollCycle.format();
        this.epoch = epoch;
        this.rollTime = rollTime;
        this.rollTimeZone = rollTimeZone;
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)RollFields.length).int32(this.length).write((WireKey)RollFields.format).text(this.format).write((WireKey)RollFields.epoch).int64(this.epoch);
        if (this.rollTime != null) {
            wire.write((WireKey)RollFields.rollTime).time(this.rollTime);
        }
        if (this.rollTimeZone != null) {
            wire.write((WireKey)RollFields.rollTimeZone).text(this.rollTimeZone.getId());
        }
    }

    public long epoch() {
        return this.epoch;
    }

    public String format() {
        return this.format;
    }

    int length() {
        return this.length;
    }

    @Nullable
    public LocalTime rollTime() {
        return this.rollTime;
    }

    @Nullable
    public ZoneId rollTimeZone() {
        return this.rollTimeZone;
    }

    public void length(int length) {
        this.length = length;
    }

    public void format(@Nullable String format) {
        this.format = format;
    }

    public void rollTime(@Nullable LocalTime rollTime) {
        this.rollTime = rollTime;
    }

    public void rollTimeZone(@Nullable ZoneId rollTimeZone) {
        this.rollTimeZone = rollTimeZone;
    }

    public void epoch(long epoch) {
        this.epoch = epoch;
    }

    public String toString() {
        return "SCQRoll{length=" + this.length + ", format='" + this.format + '\'' + ", epoch=" + this.epoch + ", rollTime=" + this.rollTime + ", rollTimeZone=" + this.rollTimeZone + '}';
    }

    static enum RollFields implements WireKey
    {
        length,
        format,
        epoch,
        rollTime,
        rollTimeZone;

    }
}

