/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.network.VanillaClientConnectionMonitor;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConnectionStrategy
extends Marshallable,
Closeable {
    default public ClientConnectionMonitor clientConnectionMonitor() {
        return new VanillaClientConnectionMonitor();
    }

    @Deprecated
    @Nullable
    public static ChronicleSocketChannel socketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, int socketConnectionTimeoutMs) throws IOException {
        return ChronicleSocketChannel.builder(socketAddress).tcpBufferSize(tcpBufferSize).socketConnectionTimeoutMs(socketConnectionTimeoutMs).open();
    }

    public ChronicleSocketChannel connect(@NotNull String var1, @NotNull SocketAddressSupplier var2, boolean var3, @NotNull FatalFailureMonitor var4) throws InterruptedException;

    @Nullable
    default public ChronicleSocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, long timeoutMs) throws IOException, InterruptedException {
        return this.openSocketChannel(socketAddress, tcpBufferSize, timeoutMs, 1);
    }

    @Nullable
    default public ChronicleSocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, long timeoutMs, int socketConnectionTimeoutMs) throws IOException, InterruptedException {
        if (!1.$assertionsDisabled && timeoutMs <= 0L) {
            throw new AssertionError();
        }
        long start = System.currentTimeMillis();
        ChronicleSocketChannel sc = ChronicleSocketChannel.builder(socketAddress).tcpBufferSize(tcpBufferSize).socketConnectionTimeoutMs(socketConnectionTimeoutMs).localBinding(this.localSocketBinding()).open();
        if (sc != null) {
            return sc;
        }
        while (true) {
            this.throwExceptionIfClosed();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            long startMs = System.currentTimeMillis();
            if (start + timeoutMs < startMs) {
                Jvm.warn().on(ConnectionStrategy.class, "Timed out attempting to connect to " + socketAddress);
                return null;
            }
            sc = ChronicleSocketChannel.builder(socketAddress).tcpBufferSize(tcpBufferSize).socketConnectionTimeoutMs(socketConnectionTimeoutMs).localBinding(this.localSocketBinding()).open();
            if (sc != null) {
                return sc;
            }
            Thread.yield();
            this.pauseBeforeReconnect(startMs);
        }
    }

    default public void pauseBeforeReconnect(long startMs) {
        long pauseMillis = startMs + this.pauseMillisBeforeReconnect() - System.currentTimeMillis();
        if (Jvm.isDebugEnabled(this.getClass())) {
            Jvm.debug().on(this.getClass(), "Waiting for reconnect " + pauseMillis + " ms");
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(pauseMillis));
    }

    default public long pauseMillisBeforeReconnect() {
        return 500L;
    }

    @Override
    default public void close() {
    }

    default public boolean isClosed() {
        return false;
    }

    default public ConnectionStrategy open() {
        return this;
    }

    default public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new ClosedIllegalStateException("Closed");
        }
    }

    default public long minPauseSec() {
        return Jvm.getInteger((String)"connectionStrategy.pause.min.secs", (Integer)5).intValue();
    }

    default public long maxPauseSec() {
        return Jvm.getInteger((String)"connectionStrategy.pause.max.secs", (Integer)5).intValue();
    }

    @Nullable
    default public InetSocketAddress localSocketBinding() throws SocketException, UnknownHostException, IllegalStateException {
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

