/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.network.tcp.VanillaSocketChannel;

public class FastJ8SocketChannel
extends VanillaSocketChannel {
    final FileDescriptor fd;
    private final Object readLock;
    volatile boolean open;
    private volatile boolean blocking;

    public FastJ8SocketChannel(SocketChannel socketChannel) {
        super(socketChannel);
        this.fd = (FileDescriptor)Jvm.getValue((Object)socketChannel, (String)"fd");
        this.open = socketChannel.isOpen();
        this.blocking = socketChannel.isBlocking();
        this.readLock = Jvm.getValue((Object)socketChannel, (String)"readLock");
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        this.throwExceptionIfClosed();
        if (buf == null) {
            throw new NullPointerException();
        }
        if (this.isBlocking() || this.isClosed() || !IOTools.isDirectBuffer((ByteBuffer)buf)) {
            return super.read(buf);
        }
        return this.read0(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read0(ByteBuffer buf) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (Thread.interrupted()) {
                throw new IOException(new InterruptedException());
            }
            return this.readInternal(buf);
        }
    }

    @Override
    public void configureBlocking(boolean blocking) throws IOException {
        super.configureBlocking(blocking);
        this.blocking = super.isBlocking();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    protected void performClose() {
        super.performClose();
        this.open = false;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.throwExceptionIfClosed();
        try {
            int write = super.write(byteBuffer);
            this.open &= write >= 0;
            return write;
        }
        catch (Exception e) {
            this.open = super.isOpen();
            throw e;
        }
    }

    int readInternal(ByteBuffer buf) throws IOException {
        int n = OS.read0((FileDescriptor)this.fd, (long)(IOTools.addressFor((ByteBuffer)buf) + (long)buf.position()), (int)buf.remaining());
        if (n == -3 && this.socketChannel.isOpen()) {
            return 0;
        }
        int ret = IOTools.normaliseIOStatus((int)n);
        if (ret > 0) {
            buf.position(buf.position() + ret);
        } else if (ret < 0) {
            this.open = false;
        }
        return ret;
    }
}

