/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaClusteredNetworkContext<T extends VanillaClusteredNetworkContext<T, C>, C extends ClusterContext<C, T>>
extends VanillaNetworkContext<T>
implements ClusteredNetworkContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VanillaClusteredNetworkContext.class);
    @NotNull
    private final EventLoop eventLoop;
    @NotNull
    protected final C clusterContext;

    public VanillaClusteredNetworkContext(@NotNull C clusterContext) {
        this.clusterContext = clusterContext;
        this.eventLoop = ((ClusterContext)((Object)clusterContext)).eventLoop();
        this.heartbeatListener(this::logMissedHeartbeat);
        this.serverThreadingStrategy(((ClusterContext)((Object)clusterContext)).serverThreadingStrategy());
    }

    @Override
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    public byte getLocalHostIdentifier() {
        return ((ClusterContext)((Object)this.clusterContext)).localIdentifier();
    }

    @Override
    public C clusterContext() {
        return this.clusterContext;
    }

    private boolean logMissedHeartbeat() {
        LOGGER.warn("Missed heartbeat on network context " + this.socketChannel());
        return false;
    }
}

